/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import tachyon.worker.WorkerStorage;
import tachyon.worker.hierarchy.StorageDir;

public class BlocksLocker {
    private final Map<Long, Set<Integer>> mLockedBlockIds = new HashMap<Long, Set<Integer>>();
    private final Map<Long, StorageDir> mLockedBlockIdToStorageDir = new HashMap<Long, StorageDir>();
    private final AtomicInteger mBlockLockId = new AtomicInteger(0);
    private final int mUserId;
    private final WorkerStorage mWorkerStorage;

    public BlocksLocker(WorkerStorage workerStorage, int userId) {
        this.mUserId = userId;
        this.mWorkerStorage = workerStorage;
    }

    public synchronized StorageDir lock(long blockId, int blockLockId) {
        if (!this.mLockedBlockIds.containsKey(blockId)) {
            StorageDir storageDir = this.mWorkerStorage.lockBlock(blockId, this.mUserId);
            if (storageDir != null) {
                HashSet<Integer> lockIdSet = new HashSet<Integer>();
                lockIdSet.add(blockLockId);
                this.mLockedBlockIds.put(blockId, lockIdSet);
                this.mLockedBlockIdToStorageDir.put(blockId, storageDir);
                return storageDir;
            }
            return null;
        }
        this.mLockedBlockIds.get(blockId).add(blockLockId);
        return this.mLockedBlockIdToStorageDir.get(blockId);
    }

    public synchronized int getLockId() {
        return this.mBlockLockId.incrementAndGet();
    }

    public synchronized StorageDir locked(long blockId) {
        return this.mLockedBlockIdToStorageDir.get(blockId);
    }

    public synchronized boolean unlock(long blockId, int lockId) {
        Set<Integer> lockers = this.mLockedBlockIds.get(blockId);
        if (lockers != null) {
            lockers.remove(lockId);
            if (lockers.isEmpty()) {
                this.mLockedBlockIds.remove(blockId);
                return this.mLockedBlockIdToStorageDir.remove(blockId).unlockBlock(blockId, this.mUserId);
            }
            return true;
        }
        return true;
    }
}

