/*
 * Decompiled with CFR 0.152.
 */
package tachyon.web;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.TachyonURI;
import tachyon.client.InStream;
import tachyon.client.ReadType;
import tachyon.client.TachyonFS;
import tachyon.client.TachyonFile;
import tachyon.master.MasterInfo;
import tachyon.thrift.ClientFileInfo;
import tachyon.thrift.FileDoesNotExistException;
import tachyon.thrift.InvalidPathException;

public class WebInterfaceDownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = 7329267100965731815L;
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final transient MasterInfo mMasterInfo;

    public WebInterfaceDownloadServlet(MasterInfo masterInfo) {
        this.mMasterInfo = masterInfo;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String requestPath = request.getParameter("path");
        if (requestPath == null || requestPath.isEmpty()) {
            requestPath = "/";
        }
        TachyonURI currentPath = new TachyonURI(requestPath);
        try {
            ClientFileInfo clientFileInfo = this.mMasterInfo.getClientFileInfo(currentPath);
            if (null == clientFileInfo) {
                throw new FileDoesNotExistException(currentPath.toString());
            }
            this.downloadFile(new TachyonURI(clientFileInfo.getPath()), request, response);
        }
        catch (FileDoesNotExistException fdne) {
            request.setAttribute("invalidPathError", (Object)("Error: Invalid Path " + fdne.getMessage()));
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (InvalidPathException ipe) {
            request.setAttribute("invalidPathError", (Object)("Error: Invalid Path " + ipe.getLocalizedMessage()));
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(TachyonURI path, HttpServletRequest request, HttpServletResponse response) throws FileDoesNotExistException, IOException {
        String masterAddress = "tachyon://" + this.mMasterInfo.getMasterAddress().getHostName() + ":" + this.mMasterInfo.getMasterAddress().getPort();
        TachyonFS tachyonClient = TachyonFS.get(new TachyonURI(masterAddress));
        TachyonFile tFile = tachyonClient.getFile(path);
        if (tFile == null) {
            throw new FileDoesNotExistException(path.toString());
        }
        long len = tFile.length();
        String fileName = path.getName();
        response.setContentType("application/octet-stream");
        if (len <= Integer.MAX_VALUE) {
            response.setContentLength((int)len);
        } else {
            response.addHeader("Content-Length", Long.toString(len));
        }
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        InStream is = null;
        ServletOutputStream out = null;
        try {
            is = tFile.getInStream(ReadType.NO_CACHE);
            out = response.getOutputStream();
            ByteStreams.copy((InputStream)is, (OutputStream)out);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
            if (is != null) {
                is.close();
            }
        }
        try {
            tachyonClient.close();
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
        }
    }
}

