/*
 * Decompiled with CFR 0.152.
 */
package tachyon.examples;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.TachyonURI;
import tachyon.Version;
import tachyon.client.OutStream;
import tachyon.client.TachyonByteBuffer;
import tachyon.client.TachyonFS;
import tachyon.client.TachyonFile;
import tachyon.client.WriteType;
import tachyon.examples.Utils;
import tachyon.util.CommonUtils;

public class BasicOperations
implements Callable<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final TachyonURI mMasterLocation;
    private final TachyonURI mFilePath;
    private final WriteType mWriteType;
    private final int mNumbers = 20;

    public BasicOperations(TachyonURI masterLocation, TachyonURI filePath, WriteType writeType) {
        this.mMasterLocation = masterLocation;
        this.mFilePath = filePath;
        this.mWriteType = writeType;
    }

    @Override
    public Boolean call() throws Exception {
        TachyonFS tachyonClient = TachyonFS.get(this.mMasterLocation);
        this.createFile(tachyonClient);
        this.writeFile(tachyonClient);
        return this.readFile(tachyonClient);
    }

    private void createFile(TachyonFS tachyonClient) throws IOException {
        LOG.debug("Creating file...");
        long startTimeMs = CommonUtils.getCurrentMs();
        int fileId = tachyonClient.createFile(this.mFilePath);
        CommonUtils.printTimeTakenMs(startTimeMs, LOG, "createFile with fileId " + fileId);
    }

    private void writeFile(TachyonFS tachyonClient) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(80);
        buf.order(ByteOrder.nativeOrder());
        for (int k = 0; k < 20; ++k) {
            buf.putInt(k);
        }
        buf.flip();
        LOG.debug("Writing data...");
        buf.flip();
        long startTimeMs = CommonUtils.getCurrentMs();
        TachyonFile file = tachyonClient.getFile(this.mFilePath);
        OutStream os = file.getOutStream(this.mWriteType);
        os.write(buf.array());
        os.close();
        CommonUtils.printTimeTakenMs(startTimeMs, LOG, "writeFile to file " + this.mFilePath);
    }

    private boolean readFile(TachyonFS tachyonClient) throws IOException {
        boolean pass = true;
        LOG.debug("Reading data...");
        long startTimeMs = CommonUtils.getCurrentMs();
        TachyonFile file = tachyonClient.getFile(this.mFilePath);
        TachyonByteBuffer buf = file.readByteBuffer(0);
        if (buf == null) {
            file.recache();
            buf = file.readByteBuffer(0);
        }
        buf.mData.order(ByteOrder.nativeOrder());
        for (int k = 0; k < 20; ++k) {
            pass = pass && buf.mData.getInt() == k;
        }
        buf.close();
        CommonUtils.printTimeTakenMs(startTimeMs, LOG, "readFile file " + this.mFilePath);
        return pass;
    }

    public static void main(String[] args) throws IllegalArgumentException {
        if (args.length != 3) {
            System.out.println("java -cp target/tachyon-" + Version.VERSION + "-jar-with-dependencies.jar " + "tachyon.examples.BasicOperations <TachyonMasterAddress> <FilePath> <WriteType>");
            System.exit(-1);
        }
        Utils.runExample(new BasicOperations(new TachyonURI(args[0]), new TachyonURI(args[1]), WriteType.valueOf(args[2])));
    }
}

