/*
 * Decompiled with CFR 0.152.
 */
package tachyon.conf;

import java.util.ArrayList;
import java.util.Arrays;
import tachyon.conf.CommonConf;
import tachyon.conf.Utils;
import tachyon.util.NetworkUtils;

public class MasterConf
extends Utils {
    private static MasterConf sMasterConf = null;
    public final String JOURNAL_FOLDER;
    public final String FORMAT_FILE_PREFIX;
    public final String HOSTNAME;
    public final int PORT;
    public final String MASTER_ADDRESS;
    public final int WEB_PORT;
    public final String TEMPORARY_FOLDER;
    public final int HEARTBEAT_INTERVAL_MS;
    public final int SELECTOR_THREADS;
    public final int QUEUE_SIZE_PER_SELECTOR;
    public final int SERVER_THREADS;
    public final int WORKER_TIMEOUT_MS;
    public final int WEB_THREAD_COUNT;
    public final String KEYTAB_KEY;
    public final String KEYTAB;
    public final String PRINCIPAL_KEY;
    public final String PRINCIPAL;
    public final ArrayList<String> WHITELIST = new ArrayList();

    public static synchronized void clear() {
        sMasterConf = null;
    }

    public static synchronized MasterConf get() {
        if (sMasterConf == null) {
            sMasterConf = new MasterConf();
        }
        return sMasterConf;
    }

    private MasterConf() {
        String journalFolder = MasterConf.getProperty("tachyon.master.journal.folder", CommonConf.get().TACHYON_HOME + "/journal/");
        if (!journalFolder.endsWith("/")) {
            journalFolder = journalFolder + "/";
        }
        this.JOURNAL_FOLDER = journalFolder;
        this.FORMAT_FILE_PREFIX = "_format_";
        this.HOSTNAME = MasterConf.getProperty("tachyon.master.hostname", NetworkUtils.getLocalHostName());
        this.PORT = MasterConf.getIntProperty("tachyon.master.port", 19998);
        this.MASTER_ADDRESS = (CommonConf.get().USE_ZOOKEEPER ? "tachyon-ft://" : "tachyon://") + this.HOSTNAME + ":" + this.PORT;
        this.WEB_PORT = MasterConf.getIntProperty("tachyon.master.web.port", 19999);
        this.WEB_THREAD_COUNT = MasterConf.getIntProperty("tachyon.master.web.threads", 1);
        this.TEMPORARY_FOLDER = MasterConf.getProperty("tachyon.master.temporary.folder", "/tmp");
        this.HEARTBEAT_INTERVAL_MS = MasterConf.getIntProperty("tachyon.master.heartbeat.interval.ms", 1000);
        this.SELECTOR_THREADS = MasterConf.getIntProperty("tachyon.master.selector.threads", 3);
        this.QUEUE_SIZE_PER_SELECTOR = MasterConf.getIntProperty("tachyon.master.queue.size.per.selector", 3000);
        this.SERVER_THREADS = MasterConf.getIntProperty("tachyon.master.server.threads", 2 * Runtime.getRuntime().availableProcessors());
        this.WORKER_TIMEOUT_MS = MasterConf.getIntProperty("tachyon.master.worker.timeout.ms", 10000);
        this.KEYTAB_KEY = "tachyon.master.keytab.file";
        this.KEYTAB = MasterConf.getProperty(this.KEYTAB_KEY, null);
        this.PRINCIPAL_KEY = "tachyon.master.principal";
        this.PRINCIPAL = MasterConf.getProperty(this.PRINCIPAL_KEY, null);
        this.WHITELIST.addAll(Arrays.asList(MasterConf.getProperty("tachyon.master.whitelist", "/").split(",")));
        String tPinList = MasterConf.getProperty("tachyon.master.pinlist", null);
        if (tPinList != null && !tPinList.isEmpty()) {
            System.err.println("WARNING: tachyon.master.pinlist is set but no longer supported! Please use the pin function in the TFS Shell instead.");
        }
    }
}

