/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import java.io.IOException;
import tachyon.client.InStream;
import tachyon.client.LocalBlockInStream;
import tachyon.client.ReadType;
import tachyon.client.RemoteBlockInStream;
import tachyon.client.TachyonByteBuffer;
import tachyon.client.TachyonFile;

public abstract class BlockInStream
extends InStream {
    protected final int mBlockIndex;
    protected boolean mClosed = false;

    public static BlockInStream get(TachyonFile tachyonFile, ReadType readType, int blockIndex) throws IOException {
        return BlockInStream.get(tachyonFile, readType, blockIndex, tachyonFile.getUFSConf());
    }

    public static BlockInStream get(TachyonFile tachyonFile, ReadType readType, int blockIndex, Object ufsConf) throws IOException {
        TachyonByteBuffer buf = tachyonFile.readLocalByteBuffer(blockIndex);
        if (buf != null) {
            if (readType.isPromote()) {
                tachyonFile.promoteBlock(blockIndex);
            }
            return new LocalBlockInStream(tachyonFile, readType, blockIndex, buf);
        }
        return new RemoteBlockInStream(tachyonFile, readType, blockIndex, ufsConf);
    }

    BlockInStream(TachyonFile file, ReadType readType, int blockIndex) throws IOException {
        super(file, readType);
        this.mBlockIndex = blockIndex;
    }
}

