/*
 * Decompiled with CFR 0.152.
 */
package tachyon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import tachyon.UnderFileSystem;
import tachyon.util.CommonUtils;
import tachyon.util.NetworkUtils;

public class UnderFileSystemSingleLocal
extends UnderFileSystem {
    public static UnderFileSystem getClient() {
        return new UnderFileSystemSingleLocal();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public OutputStream create(String path) throws IOException {
        FileOutputStream stream = new FileOutputStream(path);
        try {
            this.setPermission(path, "777");
        }
        catch (IOException e) {
            stream.close();
            throw e;
        }
        CommonUtils.setLocalFileStickyBit(path);
        return stream;
    }

    @Override
    public OutputStream create(String path, int blockSizeByte) throws IOException {
        return this.create(path, (short)1, blockSizeByte);
    }

    @Override
    public OutputStream create(String path, short replication, int blockSizeByte) throws IOException {
        if (replication != 1) {
            throw new IOException("UnderFileSystemSingleLocal does not provide more than one replication factor");
        }
        return this.create(path);
    }

    @Override
    public boolean delete(String path, boolean recursive) throws IOException {
        File file = new File(path);
        boolean success = true;
        if (recursive && file.isDirectory()) {
            String[] files;
            for (String child : files = file.list()) {
                success = success && this.delete(CommonUtils.concat(path, child), true);
            }
        }
        return success && file.delete();
    }

    @Override
    public boolean exists(String path) throws IOException {
        File file = new File(path);
        return file.exists();
    }

    @Override
    public long getBlockSizeByte(String path) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            throw new FileNotFoundException(path);
        }
        return 0x80000000L;
    }

    @Override
    public Object getConf() {
        return null;
    }

    @Override
    public List<String> getFileLocations(String path) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(NetworkUtils.getLocalHostName());
        return ret;
    }

    @Override
    public List<String> getFileLocations(String path, long offset) throws IOException {
        return this.getFileLocations(path);
    }

    @Override
    public long getFileSize(String path) throws IOException {
        File file = new File(path);
        return file.length();
    }

    @Override
    public long getModificationTimeMs(String path) throws IOException {
        File file = new File(path);
        return file.lastModified();
    }

    @Override
    public long getSpace(String path, UnderFileSystem.SpaceType type) throws IOException {
        File file = new File(path);
        switch (type) {
            case SPACE_TOTAL: {
                return file.getTotalSpace();
            }
            case SPACE_FREE: {
                return file.getFreeSpace();
            }
            case SPACE_USED: {
                return file.getTotalSpace() - file.getFreeSpace();
            }
        }
        throw new IOException("Unknown getSpace parameter: " + (Object)((Object)type));
    }

    @Override
    public boolean isFile(String path) throws IOException {
        File file = new File(path);
        return file.isFile();
    }

    @Override
    public String[] list(String path) throws IOException {
        File file = new File(path);
        File[] files = file.listFiles();
        if (files != null) {
            String[] rtn = new String[files.length];
            int i = 0;
            for (File f : files) {
                rtn[i++] = f.getName();
            }
            return rtn;
        }
        return null;
    }

    @Override
    public boolean mkdirs(String path, boolean createParent) throws IOException {
        File file = new File(path);
        boolean created = createParent ? file.mkdirs() : file.mkdir();
        this.setPermission(path, "777");
        CommonUtils.setLocalFileStickyBit(path);
        return created;
    }

    @Override
    public InputStream open(String path) throws IOException {
        return new FileInputStream(path);
    }

    @Override
    public boolean rename(String src, String dst) throws IOException {
        File file = new File(src);
        return file.renameTo(new File(dst));
    }

    @Override
    public void setConf(Object conf) {
    }

    @Override
    public void setPermission(String path, String posixPerm) throws IOException {
        CommonUtils.changeLocalFilePermission(path, posixPerm);
    }
}

