/*
 * Decompiled with CFR 0.152.
 */
package tachyon;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.HeartbeatExecutor;

public final class HeartbeatThread
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final String mThreadName;
    private final HeartbeatExecutor mExecutor;
    private final long mFixedExecutionIntervalMs;

    public HeartbeatThread(String threadName, HeartbeatExecutor hbExecutor, long fixedExecutionIntervalMs) {
        this.mThreadName = threadName;
        this.mExecutor = hbExecutor;
        this.mFixedExecutionIntervalMs = fixedExecutionIntervalMs;
    }

    @Override
    public void run() {
        Thread.currentThread().setName(this.mThreadName);
        try {
            while (!Thread.interrupted()) {
                long lastMs = System.currentTimeMillis();
                this.mExecutor.heartbeat();
                long executionTimeMs = System.currentTimeMillis() - lastMs;
                if (executionTimeMs > this.mFixedExecutionIntervalMs) {
                    LOG.warn(this.mThreadName + " last execution took " + executionTimeMs + " ms. Longer than " + " the mFixedExecutionIntervalMs " + this.mFixedExecutionIntervalMs);
                    continue;
                }
                Thread.sleep(this.mFixedExecutionIntervalMs - executionTimeMs);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOG.error("Uncaught exception in heartbeat executor, Heartbeat Thread shutting down", (Throwable)e);
        }
    }
}

