/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.aspectj;

import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.annotation.SuppressAjWarnings;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.interceptor.TransactionAttributeSource;

public abstract class AbstractTransactionAspect
extends TransactionAspectSupport {
    protected AbstractTransactionAspect(TransactionAttributeSource tas) {
        this.setTransactionAttributeSource(tas);
    }

    @SuppressAjWarnings(value={"adviceDidNotMatch"})
    @Before(value="transactionalMethodExecution(txObject)", argNames="txObject")
    public void ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c(Object txObject, JoinPoint.StaticPart thisJoinPointStaticPart) {
        MethodSignature methodSignature = (MethodSignature)thisJoinPointStaticPart.getSignature();
        Method method = methodSignature.getMethod();
        this.createTransactionIfNecessary(method, txObject.getClass());
    }

    @SuppressAjWarnings(value={"adviceDidNotMatch"})
    @AfterThrowing(pointcut="transactionalMethodExecution(txObject)", throwing="t", argNames="txObject,t")
    public void ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c(Object txObject, Throwable t) {
        try {
            this.completeTransactionAfterThrowing(TransactionAspectSupport.currentTransactionInfo(), t);
        }
        catch (Throwable t2) {
            this.logger.error((Object)"Failed to close transaction after throwing in a transactional method", t2);
        }
    }

    @SuppressAjWarnings(value={"adviceDidNotMatch"})
    @AfterReturning(pointcut="transactionalMethodExecution(txObject)", returning="", argNames="txObject")
    public void ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c(Object txObject) {
        this.commitTransactionAfterReturning(TransactionAspectSupport.currentTransactionInfo());
    }

    @SuppressAjWarnings(value={"adviceDidNotMatch"})
    @After(value="transactionalMethodExecution(txObject)", argNames="txObject")
    public void ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c(Object txObject) {
        this.cleanupTransactionInfo(TransactionAspectSupport.currentTransactionInfo());
    }

    @Pointcut(value="", argNames="txObject")
    protected abstract /* synthetic */ void ajc$pointcut$$transactionalMethodExecution$f28(Object var1);
}

