/*
 * Decompiled with CFR 0.152.
 */
package org.scala_tools.maven;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.plexus.util.StringUtils;
import org.scala_tools.maven.BasicArtifact;
import org.scala_tools.maven.JavaCommand;
import org.scala_tools.maven.VersionNumber;
import org.scala_tools.maven.executions.JavaMainCaller;
import org.scala_tools.maven.executions.ReflectionJavaMainCaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ScalaMojoSupport
extends AbstractMojo {
    public static final String SCALA_GROUPID = "org.scala-lang";
    public static final String SCALA_LIBRARY_ARTIFACTID = "scala-library";
    protected MavenProject project;
    protected ArtifactFactory factory;
    protected ArtifactResolver resolver;
    protected ArtifactRepository localRepo;
    protected List<?> remoteRepos;
    protected BasicArtifact[] dependencies;
    protected BasicArtifact[] compilerPlugins;
    protected String[] jvmArgs;
    protected String[] args;
    protected String scalaClassName;
    protected String scalaVersion;
    protected boolean displayCmd;
    protected boolean fork = true;
    protected boolean failOnMultipleScalaVersions = true;
    protected MavenProjectBuilder mavenProjectBuilder;

    ScalaMojoSupport() {
    }

    protected Set<Artifact> resolveDependencyArtifacts(MavenProject theProject) throws Exception {
        AndArtifactFilter filter = new AndArtifactFilter();
        filter.add((ArtifactFilter)new ScopeArtifactFilter("test"));
        filter.add(new ArtifactFilter(){

            public boolean include(Artifact artifact) {
                return !artifact.isOptional();
            }
        });
        Set artifacts = theProject.createArtifacts(this.factory, "runtime", (ArtifactFilter)filter);
        for (Artifact artifact : artifacts) {
            this.resolver.resolve(artifact, this.remoteRepos, this.localRepo);
        }
        return artifacts;
    }

    protected Set<Artifact> resolveArtifactDependencies(Artifact artifact) throws Exception {
        Artifact pomArtifact = this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "", "pom");
        MavenProject pomProject = this.mavenProjectBuilder.buildFromRepository(pomArtifact, this.remoteRepos, this.localRepo);
        return this.resolveDependencyArtifacts(pomProject);
    }

    protected void addToClasspath(String groupId, String artifactId, String version, Set<String> classpath) throws Exception {
        this.addToClasspath(this.factory.createArtifact(groupId, artifactId, version, "runtime", "jar"), classpath);
    }

    protected void addToClasspath(Artifact artifact, Set<String> classpath) throws Exception {
        this.resolver.resolve(artifact, this.remoteRepos, this.localRepo);
        classpath.add(artifact.getFile().getCanonicalPath());
        for (Artifact dep : this.resolveArtifactDependencies(artifact)) {
            classpath.add(dep.getFile().getCanonicalPath());
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.checkScalaVersion();
            this.doExecute();
        }
        catch (MojoExecutionException exc) {
            throw exc;
        }
        catch (MojoFailureException exc) {
            throw exc;
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new MojoExecutionException("wrap: " + exc, exc);
        }
    }

    protected List<Dependency> getDependencies() {
        return this.project.getCompileDependencies();
    }

    protected void checkScalaVersion() throws Exception {
        String detectedScalaVersion = null;
        for (Dependency dep : this.getDependencies()) {
            if (!SCALA_GROUPID.equals(dep.getGroupId()) || !SCALA_LIBRARY_ARTIFACTID.equals(dep.getArtifactId())) continue;
            detectedScalaVersion = dep.getVersion();
        }
        if (StringUtils.isEmpty(detectedScalaVersion)) {
            this.getLog().warn((CharSequence)"you don't define org.scala-lang:scala-library as a dependency of the project");
        } else if (StringUtils.isNotEmpty((String)this.scalaVersion)) {
            if (!this.scalaVersion.equals(detectedScalaVersion)) {
                this.getLog().warn((CharSequence)"scala library version define in dependencies doesn't match the scalaVersion of the plugin");
            }
            this.getLog().info((CharSequence)"suggestion: remove the scalaVersion from pom.xml");
        } else {
            this.scalaVersion = detectedScalaVersion;
        }
        if (StringUtils.isEmpty((String)this.scalaVersion)) {
            throw new MojoFailureException("no scalaVersion detected or set");
        }
        this.checkCorrectVersionsOfScalaLibrary();
    }

    private void checkCorrectVersionsOfScalaLibrary() throws Exception {
        this.getLog().info((CharSequence)"Checking for multiple versions of scala");
        for (Object obj : this.project.getDependencyArtifacts()) {
            this.checkArtifactForScalaVersion((Artifact)obj);
        }
    }

    private void checkArtifactForScalaVersion(Artifact artifact) throws Exception {
        this.getLog().debug((CharSequence)("Checking:" + artifact + " to see if it's a mutliple of the scala-lib"));
        if (SCALA_GROUPID.equals(artifact.getGroupId()) && SCALA_LIBRARY_ARTIFACTID.equals(artifact.getArtifactId()) && !this.scalaVersion.equalsIgnoreCase(artifact.getBaseVersion())) {
            if (this.failOnMultipleScalaVersions) {
                throw new MojoFailureException("Multiple Scala versions detected!");
            }
            this.getLog().warn((CharSequence)"Multiple Scala versions detected!");
        }
        Set<Artifact> children = this.resolveArtifactDependencies(artifact);
        this.getLog().debug((CharSequence)(artifact + " has " + children.size() + " transitive dependencies"));
        for (Artifact child : children) {
            this.checkArtifactForScalaVersion(child);
        }
    }

    protected abstract void doExecute() throws Exception;

    protected JavaMainCaller getScalaCommand() throws Exception {
        JavaMainCaller cmd = this.getEmptyScalaCommand(this.scalaClassName);
        cmd.addArgs(this.args);
        this.addCompilerPluginOptions(cmd);
        cmd.addJvmArgs(this.jvmArgs);
        return cmd;
    }

    protected JavaMainCaller getEmptyScalaCommand(String mainClass) throws Exception {
        JavaMainCaller cmd = this.fork ? new JavaCommand(this, mainClass, this.getToolClasspath(), null, null) : new ReflectionJavaMainCaller(this, mainClass, this.getToolClasspath(), null, null);
        cmd.addJvmArgs("-Xbootclasspath/a:" + this.getBootClasspath());
        return cmd;
    }

    private String getToolClasspath() throws Exception {
        HashSet<String> classpath = new HashSet<String>();
        this.addToClasspath(SCALA_GROUPID, "scala-compiler", this.scalaVersion, classpath);
        if (this.dependencies != null) {
            for (BasicArtifact artifact : this.dependencies) {
                this.addToClasspath(artifact.groupId, artifact.artifactId, artifact.version, classpath);
            }
        }
        return JavaCommand.toMultiPath(classpath.toArray(new String[classpath.size()]));
    }

    private String getBootClasspath() throws Exception {
        HashSet<String> classpath = new HashSet<String>();
        this.addToClasspath(SCALA_GROUPID, SCALA_LIBRARY_ARTIFACTID, this.scalaVersion, classpath);
        return JavaCommand.toMultiPath(classpath.toArray(new String[classpath.size()]));
    }

    protected boolean isJavaSupportedByCompiler() {
        return new VersionNumber(this.scalaVersion).compareTo(new VersionNumber("2.7.2")) >= 0;
    }

    private void addCompilerPluginOptions(JavaMainCaller scalac) throws Exception {
        for (String plugin : this.getCompilerPlugins()) {
            scalac.addArgs("-Xplugin:" + plugin);
        }
    }

    private Set<String> getCompilerPlugins() throws Exception {
        HashSet<String> plugins = new HashSet<String>();
        if (this.compilerPlugins != null) {
            HashSet<String> ignoreClasspath = new HashSet<String>();
            this.addToClasspath(SCALA_GROUPID, "scala-compiler", this.scalaVersion, ignoreClasspath);
            this.addToClasspath(SCALA_GROUPID, SCALA_LIBRARY_ARTIFACTID, this.scalaVersion, ignoreClasspath);
            for (BasicArtifact artifact : this.compilerPlugins) {
                HashSet<String> pluginClassPath = new HashSet<String>();
                this.addToClasspath(artifact.groupId, artifact.artifactId, artifact.version, pluginClassPath);
                pluginClassPath.removeAll(ignoreClasspath);
                plugins.add((String)pluginClassPath.iterator().next());
            }
        }
        return plugins;
    }
}

