/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.archiver.ArchiveFileFilter;
import org.codehaus.plexus.archiver.ArchiveFilterException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FilterEnabled;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.jboss.jdocbook.render.RenderingException;
import org.jboss.jdocbook.xslt.XSLTException;
import org.jboss.maven.plugins.jdocbook.AbstractDocBookMojo;
import org.jboss.maven.shared.resource.ResourceDelegate;

public class ResourceMojo
extends AbstractDocBookMojo {
    private final ArchiveFileFilter[] styleEntryFilters = new ArchiveFileFilter[]{new MetaInfExclusionFilter()};

    protected void process() throws RenderingException, XSLTException {
        this.stageStyleSupportArtifacts();
        this.stageProjectResources();
    }

    private void stageStyleSupportArtifacts() {
        for (Artifact artifact : this.collectArtifactsByType("jdocbook-style", true)) {
            this.getLog().debug((CharSequence)("processing support artifact : " + artifact.getId()));
            this.unpackSupportArtifact(artifact.getFile(), this.stagingDirectory, this.styleEntryFilters);
        }
    }

    protected void unpackSupportArtifact(File file, File target, ArchiveFileFilter[] entryFilters) throws RenderingException {
        this.getLog().debug((CharSequence)("unpacking support artifact [" + file.getAbsolutePath() + "] to directory [" + target.getAbsolutePath() + "]"));
        try {
            UnArchiver unArchiver;
            boolean created;
            if (!target.exists() && !(created = target.mkdirs())) {
                this.getLog().warn((CharSequence)("File-system reported problem creating directory " + target.getAbsolutePath()));
            }
            if (FilterEnabled.class.isInstance(unArchiver = this.archiverManager.getUnArchiver("jar"))) {
                ((FilterEnabled)unArchiver).setArchiveFilters(Arrays.asList(entryFilters));
            }
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(target);
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new RenderingException("Unknown archiver type", e);
        }
        catch (ArchiverException e) {
            throw new RenderingException("Error unpacking file [" + file + "] to [" + target + "]", e);
        }
        catch (IOException e) {
            throw new RenderingException("Error unpacking file [" + file + "] to [" + target + "]", e);
        }
    }

    private void stageProjectResources() throws RenderingException {
        if (this.imageResource != null) {
            new ResourceDelegate(this.project, new File(this.stagingDirectory, "images"), this.getLog()).process(this.imageResource);
        }
        if (this.cssResource != null) {
            new ResourceDelegate(this.project, new File(this.stagingDirectory, "css"), this.getLog()).process(this.cssResource);
        }
    }

    private static class MetaInfExclusionFilter
    implements ArchiveFileFilter {
        private MetaInfExclusionFilter() {
        }

        public boolean include(InputStream dataStream, String entryName) throws ArchiveFilterException {
            return !entryName.toUpperCase().startsWith("META-INF/");
        }
    }
}

