/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.jboss.jdocbook.profile.ProfilerFactory;
import org.jboss.jdocbook.render.RendererFactory;
import org.jboss.jdocbook.render.RenderingException;
import org.jboss.jdocbook.render.format.FormatPlan;
import org.jboss.jdocbook.xslt.XSLTException;
import org.jboss.maven.plugins.jdocbook.AbstractDocBookMojo;
import org.xml.sax.EntityResolver;

public class GenerationMojo
extends AbstractDocBookMojo {
    protected Set projectArtifacts;
    protected List pluginArtifacts;
    private final ProfilerFactory profilerFactory = new ProfilerFactory(this);
    private final RendererFactory rendererFactory = new RendererFactory(this);

    protected void process() throws XSLTException, RenderingException {
        boolean created;
        if (!this.sourceDirectory.exists()) {
            this.getLog().info((CharSequence)("sourceDirectory [" + this.sourceDirectory.getAbsolutePath() + "] did not exist"));
            return;
        }
        if (this.options.getDocbookVersion() == null) {
            ArrayList artifacts = new ArrayList();
            artifacts.addAll(this.projectArtifacts);
            artifacts.addAll(this.pluginArtifacts);
            for (Artifact artifact : artifacts) {
                if (!"net.sf.docbook".equals(artifact.getGroupId()) || !"docbook".equals(artifact.getArtifactId())) continue;
                this.getLog().debug((CharSequence)("Found docbook version : " + artifact.getVersion()));
                if (this.options.getDocbookVersion() != null) {
                    this.getLog().warn((CharSequence)"found multiple docbook versions");
                }
                this.options.setDocbookVersion(artifact.getVersion());
            }
        }
        if (!this.workDirectory.exists() && !(created = this.workDirectory.mkdirs())) {
            this.loggingBridge.info("Unable to create work directory {}", this.workDirectory.getAbsolutePath());
        }
        if (this.profiling.isEnabled()) {
            this.profilerFactory.buildProfiler().applyProfiling();
        }
        CatalogResolver entityResolver = this.getCatalogResolver();
        for (FormatPlan formatPlan : this.getFormatPlans()) {
            this.rendererFactory.buildRenderer(formatPlan, (EntityResolver)entityResolver).render();
        }
    }
}

