/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeResolutionListener;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.logging.Logger;
import org.jboss.jdocbook.JDocBookProcessException;
import org.jboss.jdocbook.Log;
import org.jboss.jdocbook.ValueInjection;
import org.jboss.jdocbook.i18n.Factory;
import org.jboss.jdocbook.i18n.I18nEnvironment;
import org.jboss.jdocbook.i18n.I18nSource;
import org.jboss.jdocbook.i18n.MasterTranslationDescriptor;
import org.jboss.jdocbook.render.PublishingSource;
import org.jboss.jdocbook.render.RenderingEnvironment;
import org.jboss.jdocbook.render.RenderingException;
import org.jboss.jdocbook.render.format.FormatPlan;
import org.jboss.jdocbook.render.format.StandardDocBookFormatDescriptor;
import org.jboss.jdocbook.render.format.StandardDocBookFormatDescriptors;
import org.jboss.jdocbook.util.LocaleUtils;
import org.jboss.jdocbook.util.ResourceHelper;
import org.jboss.jdocbook.xslt.TransformerBuilder;
import org.jboss.jdocbook.xslt.XSLTException;
import org.jboss.jdocbook.xslt.catalog.AbstractCatalogManager;
import org.jboss.jdocbook.xslt.catalog.ExplicitCatalogManager;
import org.jboss.jdocbook.xslt.catalog.ImplicitCatalogManager;
import org.jboss.maven.plugins.jdocbook.Format;
import org.jboss.maven.plugins.jdocbook.Injection;
import org.jboss.maven.plugins.jdocbook.Options;
import org.jboss.maven.plugins.jdocbook.Profiling;
import org.jboss.maven.util.logging.PlexusToMavenPluginLoggingBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDocBookMojo
extends AbstractMojo
implements RenderingEnvironment,
I18nEnvironment {
    public static final String PLUGIN_NAME = "jdocbook";
    protected MavenProject project;
    protected List pluginArtifacts;
    protected MavenSession session;
    protected Settings settings;
    protected ArtifactRepository localRepository;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected ArtifactCollector artifactCollector;
    protected ArchiverManager archiverManager;
    protected ArtifactResolver artifactResolver;
    protected String sourceDocumentName;
    protected File sourceDirectory;
    protected Resource imageResource;
    protected Resource cssResource;
    protected File fontsDirectory;
    protected File publishDirectory;
    protected File stagingDirectory;
    protected File workDirectory;
    protected Format[] formats;
    protected boolean attach = true;
    protected Profiling profiling = new Profiling();
    protected Options options;
    protected Injection[] injections;
    protected boolean ignoreTranslations;
    protected String masterTranslation;
    protected String[] translations;
    protected File translationBaseDirectory;
    private File resolvedMasterSourceDirectory;
    protected final Factory i18nProcesserFactory = new Factory(this);
    protected final MavenLogBridge loggingBridge = new MavenLogBridge();
    private FormatPlan[] formatPlans;
    private List<ValueInjection> valueInjections;
    private TransformerBuilder transformerBuilder;
    private CatalogResolver catalogResolver;
    private URL[] styleArtifactUrls;
    private ResourceHelper resourceHelper;

    public Factory getI18nProcesserFactory() {
        return this.i18nProcesserFactory;
    }

    public FormatPlan[] getFormatPlans() {
        return this.formatPlans;
    }

    protected void process() throws JDocBookProcessException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecuteWithProxy(Proxy proxy) throws JDocBookProcessException {
        String originalHost = null;
        String originalPort = null;
        String originalUser = null;
        String originalPswd = null;
        if (!this.empty(proxy.getHost())) {
            originalHost = System.getProperty("http.proxyHost");
            System.setProperty("http.proxyHost", proxy.getHost());
            originalPort = System.getProperty("http.proxyPort");
            System.setProperty("http.proxyPort", Integer.toString(proxy.getPort()));
        }
        if (!this.empty(proxy.getUsername())) {
            originalUser = System.getProperty("http.proxyUser");
            System.setProperty("http.proxyUser", proxy.getUsername());
        }
        if (!this.empty(proxy.getPassword())) {
            originalPswd = System.getProperty("http.proxyPassword");
            System.setProperty("http.proxyPassword", proxy.getPassword());
        }
        try {
            this.doExecute();
        }
        finally {
            if (!this.empty(proxy.getHost())) {
                System.setProperty("http.proxyHost", originalHost);
                System.setProperty("http.proxyPort", originalPort);
            }
            if (!this.empty(proxy.getUsername())) {
                System.setProperty("http.proxyUser", originalUser);
            }
            if (!this.empty(proxy.getPassword())) {
                System.setProperty("http.proxyPassword", originalPswd);
            }
        }
    }

    private boolean empty(String string) {
        return string == null || "".equals(string);
    }

    protected void doExecute() throws JDocBookProcessException {
        this.process();
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.options == null) {
            this.options = new Options();
        }
        this.formatPlans = this.determineFormatPlans();
        if (this.translationBaseDirectory == null) {
            this.translationBaseDirectory = this.sourceDirectory;
        }
        if (this.translations == null) {
            this.translations = new String[0];
        }
        this.resolvedMasterSourceDirectory = this.sourceDirectory;
        if (this.masterTranslation != null && !"".equals(this.masterTranslation)) {
            this.resolvedMasterSourceDirectory = new File(this.resolvedMasterSourceDirectory, this.masterTranslation);
        }
        try {
            if (this.settings.getActiveProxy() != null) {
                this.doExecuteWithProxy(this.settings.getActiveProxy());
            } else {
                this.doExecute();
            }
        }
        catch (XSLTException e) {
            throw new MojoExecutionException("XSLT problem", (Exception)e);
        }
        catch (RenderingException e) {
            throw new MojoExecutionException("Rendering problem", (Exception)e);
        }
        catch (JDocBookProcessException e) {
            throw new MojoExecutionException("Unexpected problem", (Exception)e);
        }
    }

    private FormatPlan[] determineFormatPlans() {
        String requestedFormat = this.getRequestedFormat();
        return requestedFormat != null ? this.resolveRestrictedFormatPlans(requestedFormat) : this.resolveUnrestrictedFormatPlans();
    }

    private FormatPlan[] resolveRestrictedFormatPlans(String requestedFormat) {
        FormatPlan[] plans = new FormatPlan[1];
        for (Format format : this.formats) {
            if (!requestedFormat.equals(format.getFormatName())) continue;
            plans[0] = this.buildFormatPlan(format);
        }
        if (plans[0] == null) {
            plans = new FormatPlan[]{};
        }
        return plans;
    }

    private FormatPlan buildFormatPlan(Format format) {
        return new FormatPlan(format, StandardDocBookFormatDescriptors.getDescriptor(format.getFormatName()));
    }

    private FormatPlan[] resolveUnrestrictedFormatPlans() {
        FormatPlan[] plans = new FormatPlan[this.formats.length];
        for (int i = 0; i < this.formats.length; ++i) {
            plans[i] = this.buildFormatPlan(this.formats[i]);
        }
        return plans;
    }

    protected String getRequestedFormat() {
        String requestedFormat = this.session.getExecutionProperties().getProperty("jdocbook.format");
        if (requestedFormat != null) {
            this.getLog().debug((CharSequence)("requested processing limited to [" + requestedFormat + "] format"));
        }
        return requestedFormat;
    }

    protected Locale getRequestedLocale() {
        Locale requestedLocale;
        String requestedLocaleStr = this.session.getExecutionProperties().getProperty("jdocbook.lang");
        Locale locale = requestedLocale = requestedLocaleStr == null ? null : this.parseLocale(requestedLocaleStr);
        if (requestedLocale != null) {
            this.getLog().debug((CharSequence)("requested processing limited to [" + this.stringify(requestedLocale) + "] lang"));
        }
        return requestedLocale;
    }

    @Override
    public Log log() {
        return this.loggingBridge;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public List<ValueInjection> getValueInjections() {
        if (this.valueInjections == null) {
            this.valueInjections = new ArrayList<ValueInjection>();
            if (this.injections != null) {
                this.valueInjections.addAll(Arrays.asList(this.injections));
            }
            if (this.options.isApplyStandardInjectionValues()) {
                this.valueInjections.add(new ValueInjection("version", this.project.getVersion()));
                SimpleDateFormat dateFormat = new SimpleDateFormat(this.options.getInjectionDateFormat());
                this.valueInjections.add(new ValueInjection("today", dateFormat.format(new Date())));
            }
        }
        return this.valueInjections;
    }

    @Override
    public TransformerBuilder getTransformerBuilder() {
        if (this.transformerBuilder == null) {
            this.transformerBuilder = new TransformerBuilder(this);
        }
        return this.transformerBuilder;
    }

    @Override
    public CatalogResolver getCatalogResolver() {
        if (this.catalogResolver == null) {
            AbstractCatalogManager catalogManager = this.options.getCatalogs() == null || this.options.getCatalogs().length == 0 ? new ImplicitCatalogManager() : new ExplicitCatalogManager(this.options.getCatalogs());
            this.catalogResolver = new CatalogResolver((CatalogManager)catalogManager);
        }
        return this.catalogResolver;
    }

    @Override
    public URL[] getClasspathUriResolverBaseUrls() {
        if (this.styleArtifactUrls == null) {
            ArrayList<URL> urlList = new ArrayList<URL>();
            if (this.getStagingDirectory() != null) {
                try {
                    urlList.add(this.getStagingDirectory().toURI().toURL());
                }
                catch (MalformedURLException e) {
                    this.getLog().warn((CharSequence)"Uanble to convert staging directory to url");
                }
            }
            for (Artifact artifact : this.project.getArtifacts()) {
                if (artifact.getFile() == null) continue;
                try {
                    urlList.add(artifact.getFile().toURI().toURL());
                }
                catch (MalformedURLException e) {
                    this.getLog().warn((CharSequence)("Uanble to retrieve artifact url [" + artifact.getId() + "]"));
                }
            }
            if (this.pluginArtifacts != null) {
                for (Artifact artifact : this.pluginArtifacts) {
                    if (artifact.getFile() == null) continue;
                    try {
                        urlList.add(artifact.getFile().toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        this.getLog().warn((CharSequence)("Uanble to retrieve artifact url [" + artifact.getId() + "]"));
                    }
                }
            }
            this.styleArtifactUrls = urlList.toArray(new URL[urlList.size()]);
        }
        return this.styleArtifactUrls;
    }

    @Override
    public ResourceHelper getResourceHelper() {
        if (this.resourceHelper == null) {
            this.resourceHelper = new ResourceHelper(this);
        }
        return this.resourceHelper;
    }

    @Override
    public FormatPlan getFormatPlan(StandardDocBookFormatDescriptor format) {
        for (FormatPlan plan : this.formatPlans) {
            if (!plan.getName().equals(format.getName())) continue;
            return plan;
        }
        return null;
    }

    @Override
    public File getStagingDirectory() {
        return this.stagingDirectory;
    }

    @Override
    public File getWorkDirectory() {
        return this.workDirectory;
    }

    @Override
    public File[] getFontDirectories() {
        File stagedFontsDirectory;
        ArrayList<File> directories = new ArrayList<File>();
        if (this.fontsDirectory != null && this.fontsDirectory.exists()) {
            directories.add(this.fontsDirectory);
        }
        if ((stagedFontsDirectory = new File(this.getStagingDirectory(), "fonts")).exists()) {
            directories.add(stagedFontsDirectory);
        }
        return directories.toArray(new File[directories.size()]);
    }

    @Override
    public Profiling getProfilingConfiguration() {
        return this.profiling;
    }

    public File getFontStagingDirectory() {
        return new File(this.getStagingDirectory(), "fonts");
    }

    @Override
    public List<PublishingSource> getPublishingSources(boolean excludeIngoredTranslations) {
        Locale requestedLocale = this.getRequestedLocale();
        boolean requestedLocaleIsTranslation = requestedLocale != null && !this.stringify(requestedLocale).equals(this.masterTranslation);
        boolean skipAllTranslations = this.ignoreTranslations && excludeIngoredTranslations && !requestedLocaleIsTranslation;
        ArrayList<PublishingSource> descriptors = new ArrayList<PublishingSource>();
        MasterTranslationDescriptorImpl masterTranslationImpl = new MasterTranslationDescriptorImpl();
        if (requestedLocale == null || requestedLocale.equals(masterTranslationImpl.getLocale())) {
            descriptors.add(new MasterTranslationDescriptorImpl());
        }
        if (skipAllTranslations) {
            this.getLog().info((CharSequence)"Skipping all translations");
        } else {
            for (String localeStr : this.translations) {
                boolean skipThisLocale;
                Locale locale = this.parseLocale(localeStr);
                boolean bl = skipThisLocale = requestedLocale != null && !requestedLocale.equals(locale) && excludeIngoredTranslations;
                if (skipThisLocale) {
                    this.getLog().debug((CharSequence)("skipping non-requested lang [" + localeStr + "]"));
                    continue;
                }
                descriptors.add(new OtherTranslationDescriptorImpl(locale));
            }
        }
        return descriptors;
    }

    @Override
    public MasterTranslationDescriptor getMasterTranslationDescriptor() {
        return new MasterTranslationDescriptorImpl();
    }

    @Override
    public List<I18nSource> getI18nSources(boolean excludeIngoredTranslations) {
        boolean skipAllTranslations;
        ArrayList<I18nSource> descriptors = new ArrayList<I18nSource>();
        Locale requestedLocale = this.getRequestedLocale();
        boolean requestedLocaleIsTranslation = requestedLocale != null && !this.stringify(requestedLocale).equals(this.masterTranslation);
        boolean bl = skipAllTranslations = this.ignoreTranslations && excludeIngoredTranslations && !requestedLocaleIsTranslation;
        if (skipAllTranslations) {
            this.getLog().info((CharSequence)"Skipping all translations");
        } else {
            for (String localeStr : this.translations) {
                boolean skipThisLocale;
                Locale locale = this.parseLocale(localeStr);
                boolean bl2 = skipThisLocale = requestedLocale != null && !requestedLocale.equals(locale) && excludeIngoredTranslations;
                if (skipThisLocale) {
                    this.getLog().debug((CharSequence)("skipping non-requested lang [" + localeStr + "]"));
                    continue;
                }
                descriptors.add(new OtherTranslationDescriptorImpl(locale));
            }
        }
        return descriptors;
    }

    protected File determinePublishingDirectory(String lang) {
        return new File(this.publishDirectory, lang);
    }

    protected File determineXslFoDirectory(String lang) {
        return new File(new File(this.workDirectory, "xsl-fo"), lang);
    }

    protected File determineProfilingDirectory(String lang) {
        return new File(new File(this.workDirectory, "profile"), lang);
    }

    protected File determineTranslationDirectory(String lang) {
        return new File(this.translationBaseDirectory, lang);
    }

    protected File determineTranslatedXmlDirectory(String lang) {
        return new File(new File(this.workDirectory, "xml"), lang);
    }

    protected List<Artifact> collectArtifactsByType(String type, boolean transitivesFirst) {
        Set dependencyArtifacts = this.project.getArtifacts();
        dependencyArtifacts.addAll(this.pluginArtifacts);
        DependencyTreeResolutionListener listener = new DependencyTreeResolutionListener((Logger)new PlexusToMavenPluginLoggingBridge(this.getLog()));
        try {
            this.artifactCollector.collect(dependencyArtifacts, this.project.getArtifact(), this.project.getManagedVersionMap(), this.localRepository, this.project.getRemoteArtifactRepositories(), this.artifactMetadataSource, null, Collections.singletonList(listener));
        }
        catch (AbstractArtifactResolutionException e) {
            throw new JDocBookProcessException("Cannot build project dependency tree", e);
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        this.processNode(listener.getRootNode(), artifacts, type, transitivesFirst);
        return artifacts;
    }

    private void processNode(DependencyNode node, List<Artifact> artifacts, String type, boolean transitivesFirst) {
        Artifact artifact = node.getArtifact();
        boolean isProjectArtifact = this.project.getArtifact().getId().equals(artifact.getId());
        if (!isProjectArtifact) {
            this.resolveArtifact(artifact);
        }
        if (!isProjectArtifact && !transitivesFirst && this.include(node.getArtifact(), type)) {
            artifacts.add(node.getArtifact());
        }
        for (DependencyNode child : node.getChildren()) {
            this.processNode(child, artifacts, type, transitivesFirst);
        }
        if (!isProjectArtifact && transitivesFirst && this.include(node.getArtifact(), type)) {
            artifacts.add(node.getArtifact());
        }
    }

    private void resolveArtifact(Artifact artifact) {
        try {
            this.artifactResolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new JDocBookProcessException("Unable to resolve artifact [" + artifact.getId() + "]", e);
        }
        catch (ArtifactNotFoundException e) {
            throw new JDocBookProcessException("Unable to locate artifact [" + artifact.getId() + "]", e);
        }
    }

    private boolean include(Artifact artifact, String matchingType) {
        return matchingType.equals(artifact.getType());
    }

    protected Locale parseLocale(String locale) {
        return LocaleUtils.parse(locale, this.options.getLocaleSeparator());
    }

    protected String stringify(Locale locale) {
        return LocaleUtils.render(locale, this.options.getLocaleSeparator());
    }

    protected class MavenLogBridge
    implements Log {
        protected MavenLogBridge() {
        }

        public void trace(String message) {
            AbstractDocBookMojo.this.getLog().debug((CharSequence)message);
        }

        public void trace(String message, Object ... args) {
            if (AbstractDocBookMojo.this.getLog().isDebugEnabled()) {
                AbstractDocBookMojo.this.getLog().debug((CharSequence)MessageFormat.format(message, args));
            }
        }

        public void info(String message) {
            AbstractDocBookMojo.this.getLog().info((CharSequence)message);
        }

        public void info(String message, Object ... args) {
            if (AbstractDocBookMojo.this.getLog().isInfoEnabled()) {
                AbstractDocBookMojo.this.getLog().info((CharSequence)MessageFormat.format(message, args));
            }
        }

        public void info(String message, Throwable exception) {
            AbstractDocBookMojo.this.getLog().info((CharSequence)message, exception);
        }

        public void info(String message, Throwable exception, Object ... args) {
            if (AbstractDocBookMojo.this.getLog().isInfoEnabled()) {
                AbstractDocBookMojo.this.getLog().info((CharSequence)MessageFormat.format(message, args), exception);
            }
        }

        public void error(String message) {
            AbstractDocBookMojo.this.getLog().error((CharSequence)message);
        }

        public void error(String message, Object ... args) {
            if (AbstractDocBookMojo.this.getLog().isErrorEnabled()) {
                AbstractDocBookMojo.this.getLog().error((CharSequence)MessageFormat.format(message, args));
            }
        }

        public void error(String message, Throwable exception) {
            AbstractDocBookMojo.this.getLog().error((CharSequence)message, exception);
        }

        public void error(String message, Throwable exception, Object ... args) {
            if (AbstractDocBookMojo.this.getLog().isErrorEnabled()) {
                AbstractDocBookMojo.this.getLog().error((CharSequence)MessageFormat.format(message, args), exception);
            }
        }
    }

    private class OtherTranslationDescriptorImpl
    implements PublishingSource,
    I18nSource {
        private final Locale locale;

        private OtherTranslationDescriptorImpl(Locale locale) {
            this.locale = locale;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public FormatPlan[] getFormatPlans() {
            return AbstractDocBookMojo.this.formatPlans;
        }

        public File resolveDocumentFile() {
            return new File(AbstractDocBookMojo.this.determineTranslatedXmlDirectory(AbstractDocBookMojo.this.stringify(this.locale)), AbstractDocBookMojo.this.sourceDocumentName);
        }

        public File resolvePublishingDirectory() {
            return AbstractDocBookMojo.this.determinePublishingDirectory(AbstractDocBookMojo.this.stringify(this.locale));
        }

        public File resolveXslFoDirectory() {
            return AbstractDocBookMojo.this.determineXslFoDirectory(AbstractDocBookMojo.this.stringify(this.locale));
        }

        public File resolveProfilingDirectory() {
            return AbstractDocBookMojo.this.determineProfilingDirectory(AbstractDocBookMojo.this.stringify(this.locale));
        }

        public File resolvePoDirectory() {
            return AbstractDocBookMojo.this.determineTranslationDirectory(AbstractDocBookMojo.this.stringify(this.locale));
        }

        public File resolveTranslatedXmlDirectory() {
            return AbstractDocBookMojo.this.determineTranslatedXmlDirectory(AbstractDocBookMojo.this.stringify(this.locale));
        }

        public File resolveProfiledDocumentFile() {
            return new File(this.resolveProfilingDirectory(), AbstractDocBookMojo.this.sourceDocumentName);
        }
    }

    private class MasterTranslationDescriptorImpl
    implements PublishingSource,
    MasterTranslationDescriptor {
        private MasterTranslationDescriptorImpl() {
        }

        public Locale getLocale() {
            return LocaleUtils.parse(AbstractDocBookMojo.this.masterTranslation, AbstractDocBookMojo.this.options.getLocaleSeparator());
        }

        public File resolveMasterDocument() {
            return new File(AbstractDocBookMojo.this.resolvedMasterSourceDirectory, AbstractDocBookMojo.this.sourceDocumentName);
        }

        public File resolvePotDirectory() {
            return new File(AbstractDocBookMojo.this.translationBaseDirectory, "pot");
        }

        public FormatPlan[] getFormatPlans() {
            return AbstractDocBookMojo.this.formatPlans;
        }

        public File resolveDocumentFile() {
            return this.resolveMasterDocument();
        }

        public File resolvePublishingDirectory() {
            return AbstractDocBookMojo.this.determinePublishingDirectory(AbstractDocBookMojo.this.masterTranslation);
        }

        public File resolveXslFoDirectory() {
            return AbstractDocBookMojo.this.determineXslFoDirectory(AbstractDocBookMojo.this.masterTranslation);
        }

        public File resolveProfilingDirectory() {
            return AbstractDocBookMojo.this.determineProfilingDirectory(AbstractDocBookMojo.this.masterTranslation);
        }

        public File resolveProfiledDocumentFile() {
            return new File(this.resolveProfilingDirectory(), AbstractDocBookMojo.this.sourceDocumentName);
        }
    }
}

