/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.sax.SAXSource;
import net.socialchange.doctype.Doctype;
import net.socialchange.doctype.DoctypeChangerStream;
import net.socialchange.doctype.DoctypeGenerator;
import net.socialchange.doctype.DoctypeImpl;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.jboss.jdocbook.JDocBookProcessException;
import org.jboss.jdocbook.ValueInjection;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils
extends org.codehaus.plexus.util.FileUtils {
    public static final FileFilter ACCEPT_ALL = new FileFilter(){

        public boolean accept(File pathname) {
            return true;
        }
    };

    public static SAXSource createSAXSource(File file, EntityResolver resolver, boolean xincludeAware, final List<ValueInjection> valueInjections) {
        try {
            boolean injectionsDefined = valueInjections != null && !valueInjections.isEmpty();
            SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
            factory.setXIncludeAware(xincludeAware);
            XMLReader reader = factory.newSAXParser().getXMLReader();
            reader.setEntityResolver(resolver);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            reader.setFeature("http://xml.org/sax/features/validation", false);
            try {
                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
                if (injectionsDefined) {
                    DoctypeChangerStream changerStream = new DoctypeChangerStream((InputStream)inputStream);
                    changerStream.setGenerator(new DoctypeGenerator(){

                        public Doctype generate(Doctype doctype) {
                            String root = doctype == null ? null : doctype.getRootElement();
                            String pubId = doctype == null ? null : doctype.getPublicId();
                            String sysId = doctype == null ? null : doctype.getSystemId();
                            StringBuffer internalSubset = new StringBuffer();
                            FileUtils.buildInjectedInternalEntitySubset(internalSubset, valueInjections);
                            if (doctype != null && doctype.getInternalSubset() != null) {
                                internalSubset.append(doctype.getInternalSubset()).append('\n');
                            }
                            return new DoctypeImpl(root, pubId, sysId, internalSubset.toString());
                        }
                    });
                    inputStream = changerStream;
                }
                InputSource source = new InputSource(inputStream);
                source.setSystemId(file.toURI().toURL().toString());
                return new SAXSource(reader, source);
            }
            catch (FileNotFoundException e) {
                throw new JDocBookProcessException("unable to locate source file", e);
            }
            catch (MalformedURLException e) {
                throw new JDocBookProcessException("unexpected problem converting file to URL", e);
            }
        }
        catch (ParserConfigurationException e) {
            throw new JDocBookProcessException("unable to build SAX Parser/Factory [" + e.getMessage() + "]", e);
        }
        catch (SAXException e) {
            throw new JDocBookProcessException("unable to build SAX Parser/Factory [" + e.getMessage() + "]", e);
        }
    }

    public static String determineRelativity(File file, File basedir) {
        String directory;
        String basedirPath = FileUtils.resolveFullPathName(basedir);
        if (basedirPath.equals(directory = FileUtils.resolveFullPathName(file.getParentFile()))) {
            return null;
        }
        int baseStart = directory.indexOf(basedirPath);
        if (baseStart < 0) {
            throw new RuntimeException("Included file did not seem to be relative to basedir!");
        }
        String relativity = directory.substring(basedirPath.length() + 1);
        while (relativity.startsWith("/")) {
            relativity = relativity.substring(1);
        }
        return relativity;
    }

    public static long findMostRecentTimestamp(File directory, FileFilter acceptor) {
        return FileUtils.findMostRecentTimestamp(0L, directory, acceptor);
    }

    private static long findMostRecentTimestamp(long current, File directory, FileFilter acceptor) {
        long local = 0L;
        for (File subPath : directory.listFiles()) {
            long temp = subPath.isDirectory() ? FileUtils.findMostRecentTimestamp(current, directory, acceptor) : (acceptor.accept(subPath) ? subPath.lastModified() : local);
            if (temp <= local) continue;
            local = temp;
        }
        return local > current ? local : current;
    }

    public static long findLeastRecentTimestamp(File directory, FileFilter acceptor) {
        return FileUtils.findLeastRecentTimestamp(Long.MAX_VALUE, directory, acceptor);
    }

    public static long findLeastRecentTimestamp(long current, File directory, FileFilter acceptor) {
        long local = Long.MAX_VALUE;
        for (File subPath : directory.listFiles()) {
            long temp = subPath.isDirectory() ? FileUtils.findLeastRecentTimestamp(current, directory, acceptor) : (acceptor.accept(subPath) ? subPath.lastModified() : local);
            if (temp >= local) continue;
            local = temp;
        }
        return local < current ? local : current;
    }

    public static String resolveFullPathName(File path) {
        return path.getAbsolutePath();
    }

    private static void buildInjectedInternalEntitySubset(StringBuffer buffer, List<ValueInjection> valueInjections) {
        for (ValueInjection injection : valueInjections) {
            buffer.append("<!ENTITY ").append(injection.getName()).append(" \"").append(injection.getValue()).append("\">\n");
        }
    }
}

