/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.render.format;

import java.io.File;
import org.codehaus.plexus.util.FileUtils;
import org.jboss.jdocbook.render.format.StandardDocBookFormatDescriptor;
import org.jboss.jdocbook.render.format.TargetNamingStrategy;
import org.jboss.jdocbook.render.format.UserFormatConfiguration;
import org.jboss.jdocbook.util.DocBookProfilingStrategy;

public class FormatPlan {
    private final String name;
    private final String stylesheetResource;
    private final String correspondingDocBookStylesheetResource;
    private final boolean imagePathSettingRequired;
    private final boolean imageCopyingRequired;
    private final boolean doingChunking;
    private final DocBookProfilingStrategy profiling;
    private final TargetNamingStrategy targetNamingStrategy;

    public FormatPlan(final UserFormatConfiguration userFormatConfiguration, final StandardDocBookFormatDescriptor docBookFormatDescriptor) {
        this(userFormatConfiguration, docBookFormatDescriptor, new TargetNamingStrategy(){

            public String determineTargetFileName(File source) {
                return userFormatConfiguration.getFinalName() == null ? FileUtils.basename((String)source.getAbsolutePath()) + docBookFormatDescriptor.getStandardFileExtension() : userFormatConfiguration.getFinalName();
            }
        });
    }

    public FormatPlan(UserFormatConfiguration userFormatConfiguration, StandardDocBookFormatDescriptor docBookFormatDescriptor, TargetNamingStrategy targetNamingStrategy) {
        this.name = userFormatConfiguration.getFormatName();
        this.profiling = DocBookProfilingStrategy.parse(userFormatConfiguration.getProfilingTypeName());
        this.stylesheetResource = userFormatConfiguration.getStylesheetResource() != null ? userFormatConfiguration.getStylesheetResource() : (DocBookProfilingStrategy.SINGLE_PASS == this.profiling ? docBookFormatDescriptor.getProfiledStylesheetResource() : docBookFormatDescriptor.getStylesheetResource());
        this.correspondingDocBookStylesheetResource = DocBookProfilingStrategy.SINGLE_PASS == this.profiling ? docBookFormatDescriptor.getProfiledStylesheetResource() : docBookFormatDescriptor.getStylesheetResource();
        this.imagePathSettingRequired = userFormatConfiguration.getImagePathSettingRequired() == null ? docBookFormatDescriptor.isImagePathSettingRequired() : userFormatConfiguration.getImagePathSettingRequired().booleanValue();
        this.imageCopyingRequired = userFormatConfiguration.getImageCopyingRequired() == null ? docBookFormatDescriptor.isImageCopyingRequired() : userFormatConfiguration.getImageCopyingRequired().booleanValue();
        this.doingChunking = userFormatConfiguration.getDoingChunking() == null ? docBookFormatDescriptor.isDoingChunking() : userFormatConfiguration.getDoingChunking().booleanValue();
        this.targetNamingStrategy = targetNamingStrategy;
    }

    public FormatPlan(String name, String stylesheetResource, String correspondingDocBookStylesheetResource, boolean imagePathSettingRequired, boolean imageCopyingRequired, boolean doingChunking, DocBookProfilingStrategy profiling, TargetNamingStrategy targetNamingStrategy) {
        this.name = name;
        this.stylesheetResource = stylesheetResource;
        this.correspondingDocBookStylesheetResource = correspondingDocBookStylesheetResource;
        this.imagePathSettingRequired = imagePathSettingRequired;
        this.imageCopyingRequired = imageCopyingRequired;
        this.doingChunking = doingChunking;
        this.profiling = profiling;
        this.targetNamingStrategy = targetNamingStrategy;
    }

    public String getName() {
        return this.name;
    }

    public String getStylesheetResource() {
        return this.stylesheetResource;
    }

    public String getCorrespondingDocBookStylesheetResource() {
        return this.correspondingDocBookStylesheetResource;
    }

    public boolean isImagePathSettingRequired() {
        return this.imagePathSettingRequired;
    }

    public boolean isImageCopyingRequired() {
        return this.imageCopyingRequired;
    }

    public boolean isDoingChunking() {
        return this.doingChunking;
    }

    public TargetNamingStrategy getTargetNamingStrategy() {
        return this.targetNamingStrategy;
    }

    public DocBookProfilingStrategy getProfiling() {
        return this.profiling;
    }
}

