/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.profile;

import java.io.File;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.jboss.jdocbook.profile.Profiler;
import org.jboss.jdocbook.render.PublishingSource;
import org.jboss.jdocbook.render.RenderingEnvironment;
import org.jboss.jdocbook.render.RenderingException;
import org.jboss.jdocbook.util.FileUtils;
import org.jboss.jdocbook.util.LocaleUtils;
import org.jboss.jdocbook.xslt.XSLTException;
import org.xml.sax.EntityResolver;

class ProfilerImpl
implements Profiler {
    private final RenderingEnvironment environment;

    public ProfilerImpl(RenderingEnvironment environment) {
        this.environment = environment;
    }

    public void applyProfiling() {
        try {
            for (PublishingSource source : this.environment.getPublishingSources(true)) {
                boolean created;
                File targetFile = source.resolveProfiledDocumentFile();
                if (!targetFile.getParentFile().exists() && !(created = targetFile.getParentFile().mkdirs())) {
                    this.environment.log().info("Unable to create parent directory " + targetFile.getAbsolutePath());
                }
                this.environment.log().info("applying DocBook profiling [" + targetFile.getAbsolutePath() + "]");
                Transformer xslt = this.environment.getTransformerBuilder().buildStandardTransformer("profiling/profile.xsl");
                String lang = LocaleUtils.render(source.getLocale(), this.environment.getOptions().getLocaleSeparator());
                xslt.setParameter("l10n.gentext.language", lang);
                String profilingAttributeName = this.environment.getProfilingConfiguration().getAttributeName();
                if (profilingAttributeName == null || "lang".equals(profilingAttributeName)) {
                    xslt.setParameter("profile.attribute", "lang");
                    xslt.setParameter("profile.lang", lang);
                } else {
                    xslt.setParameter("profile.attribute", profilingAttributeName);
                    xslt.setParameter("profile.value", this.environment.getProfilingConfiguration().getAttributeValue());
                }
                xslt.transform(this.buildSource(source.resolveDocumentFile()), this.buildResult(targetFile));
            }
        }
        catch (TransformerException e) {
            throw new XSLTException("error performing translation [" + e.getLocationAsString() + "] : " + e.getMessage(), e);
        }
    }

    private Source buildSource(File sourceFile) throws RenderingException {
        return FileUtils.createSAXSource(sourceFile, (EntityResolver)this.environment.getCatalogResolver(), this.environment.getOptions().isXincludeSupported(), this.environment.getValueInjections());
    }

    protected Result buildResult(File targetFile) throws RenderingException, XSLTException {
        return new StreamResult(targetFile);
    }
}

