/*
 * (c) 2001-2009, Progress Software Corporation and/or its subsidiaries or affiliates.  All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.fusesource.commons.management.noop;

import org.fusesource.commons.management.Statistic;

/**
 * An implementation of the Statistic interface that acts as a sink and does nothing.
 * <p>
 * Intended for use when no management is required.
 */
public class StatisticImpl implements Statistic {

    public long getValue() {
        return -1;
    }

    public long getUpdateCount() {
        return 0;
    }

    public void increment() {
    }

    public void updateValue(long value) {
    }

    public void reset() {
    }

}
