/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.phase;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.phase.AssemblyArchiverPhase;
import org.apache.maven.plugin.assembly.archive.task.AddArtifactTask;
import org.apache.maven.plugin.assembly.archive.task.AddDependencySetsTask;
import org.apache.maven.plugin.assembly.archive.task.AddFileSetsTask;
import org.apache.maven.plugin.assembly.artifact.DependencyResolver;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.DependencySet;
import org.apache.maven.plugin.assembly.model.FileSet;
import org.apache.maven.plugin.assembly.model.ModuleBinaries;
import org.apache.maven.plugin.assembly.model.ModuleSet;
import org.apache.maven.plugin.assembly.model.ModuleSources;
import org.apache.maven.plugin.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugin.assembly.utils.FilterUtils;
import org.apache.maven.plugin.assembly.utils.ProjectUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;

public class ModuleSetAssemblyPhase
extends AbstractLogEnabled
implements AssemblyArchiverPhase {
    private MavenProjectBuilder projectBuilder;
    private DependencyResolver dependencyResolver;

    public ModuleSetAssemblyPhase() {
    }

    public ModuleSetAssemblyPhase(MavenProjectBuilder projectBuilder, DependencyResolver dependencyResolver, Logger logger) {
        this.projectBuilder = projectBuilder;
        this.dependencyResolver = dependencyResolver;
        this.enableLogging(logger);
    }

    public void execute(Assembly assembly, Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException {
        List moduleSets = assembly.getModuleSets();
        Iterator i = moduleSets.iterator();
        while (i.hasNext()) {
            ModuleSet moduleSet = (ModuleSet)i.next();
            Set moduleProjects = this.getModuleProjects(moduleSet, configSource, moduleSet.isIncludeSubModules());
            ModuleSources sources = moduleSet.getSources();
            ModuleBinaries binaries = moduleSet.getBinaries();
            if (sources == null && binaries == null) {
                this.getLogger().warn("Encountered ModuleSet with no sources or binaries specified. Skipping.");
                continue;
            }
            this.addModuleSourceFileSets(moduleSet.getSources(), moduleProjects, archiver, configSource);
            this.addModuleBinaries(moduleSet.getBinaries(), moduleProjects, archiver, configSource);
        }
    }

    protected void addModuleBinaries(ModuleBinaries binaries, Set projects, Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException {
        if (binaries == null) {
            return;
        }
        HashSet moduleProjects = new HashSet(projects);
        Iterator it = moduleProjects.iterator();
        while (it.hasNext()) {
            MavenProject project = (MavenProject)it.next();
            if (!"pom".equals(project.getPackaging())) continue;
            String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
            this.getLogger().debug("Excluding POM-packaging module: " + projectId);
            it.remove();
        }
        String classifier = binaries.getAttachmentClassifier();
        Iterator j = moduleProjects.iterator();
        while (j.hasNext()) {
            MavenProject project = (MavenProject)j.next();
            Artifact artifact = null;
            if (classifier == null) {
                this.getLogger().debug("Processing binary artifact for module project: " + project.getId());
                artifact = project.getArtifact();
            } else {
                this.getLogger().debug("Processing binary attachment: " + classifier + " for module project: " + project.getId());
                List attachments = project.getAttachedArtifacts();
                if (attachments != null && !attachments.isEmpty()) {
                    Iterator attachmentIterator = attachments.iterator();
                    while (attachmentIterator.hasNext()) {
                        Artifact attachment = (Artifact)attachmentIterator.next();
                        if (!classifier.equals(attachment.getClassifier())) continue;
                        artifact = attachment;
                        break;
                    }
                }
                if (artifact == null) {
                    throw new InvalidAssemblerConfigurationException("Cannot find attachment with classifier: " + classifier + " in module project: " + project.getId() + ". Please exclude this module from the module-set.");
                }
            }
            this.addArtifact(artifact, project, archiver, configSource, binaries);
        }
        List<DependencySet> depSets = binaries.getDependencySets();
        if ((depSets == null || depSets.isEmpty()) && binaries.isIncludeDependencies()) {
            DependencySet impliedDependencySet = new DependencySet();
            impliedDependencySet.setOutputDirectory(binaries.getOutputDirectory());
            impliedDependencySet.setOutputFileNameMapping(binaries.getOutputFileNameMapping());
            impliedDependencySet.setFileMode(binaries.getFileMode());
            impliedDependencySet.setDirectoryMode(binaries.getDirectoryMode());
            impliedDependencySet.setExcludes(binaries.getExcludes());
            impliedDependencySet.setIncludes(binaries.getIncludes());
            impliedDependencySet.setUnpack(binaries.isUnpack());
            depSets = Collections.singletonList(impliedDependencySet);
        }
        if (depSets != null) {
            this.getLogger().warn("NOTE: Currently, inclusion of module dependencies may produce unpredictable results if a version conflict occurs.");
            Iterator it2 = moduleProjects.iterator();
            while (it2.hasNext()) {
                MavenProject moduleProject = (MavenProject)it2.next();
                this.getLogger().debug("Processing binary dependencies for module project: " + moduleProject.getId());
                AddDependencySetsTask task = new AddDependencySetsTask(depSets, moduleProject, this.projectBuilder, this.dependencyResolver, this.getLogger());
                task.setDefaultOutputDirectory(binaries.getOutputDirectory());
                task.setDefaultOutputFileNameMapping(binaries.getOutputFileNameMapping());
                task.execute(archiver, configSource);
            }
        }
    }

    protected List collectExcludesFromQueuedArtifacts(Set visitedArtifacts, List binaryExcludes) {
        ArrayList excludes = binaryExcludes;
        excludes = excludes == null ? new ArrayList() : new ArrayList(excludes);
        Iterator it = visitedArtifacts.iterator();
        while (it.hasNext()) {
            excludes.add(it.next());
        }
        return excludes;
    }

    protected void addArtifact(Artifact artifact, MavenProject project, Archiver archiver, AssemblerConfigurationSource configSource, ModuleBinaries binaries) throws ArchiveCreationException, AssemblyFormattingException {
        if (artifact.getFile() == null) {
            throw new ArchiveCreationException("Artifact: " + artifact.getId() + " (included by module) does not have an artifact with a file. " + "Please ensure the package phase is run before the assembly is generated.");
        }
        AddArtifactTask task = new AddArtifactTask(artifact, this.getLogger());
        task.setFileNameMapping(binaries.getOutputFileNameMapping());
        task.setOutputDirectory(binaries.getOutputDirectory());
        task.setProject(project);
        task.setDirectoryMode(binaries.getDirectoryMode());
        task.setFileMode(binaries.getFileMode());
        task.setUnpack(binaries.isUnpack());
        task.execute(archiver, configSource);
    }

    protected void addModuleSourceFileSets(ModuleSources sources, Set moduleProjects, Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException {
        List<FileSet> subFileSets;
        if (sources == null) {
            return;
        }
        ArrayList<FileSet> fileSets = new ArrayList<FileSet>();
        if (this.isDeprecatedModuleSourcesConfigPresent(sources)) {
            FileSet fs = new FileSet();
            fs.setOutputDirectory(sources.getOutputDirectory());
            fs.setIncludes(sources.getIncludes());
            fs.setExcludes(sources.getExcludes());
            fs.setUseDefaultExcludes(sources.isUseDefaultExcludes());
            fileSets.add(fs);
        }
        if ((subFileSets = sources.getFileSets()) == null || subFileSets.isEmpty()) {
            FileSet fs = new FileSet();
            fs.setDirectory("src");
            subFileSets = Collections.singletonList(fs);
        }
        fileSets.addAll(subFileSets);
        Iterator j = moduleProjects.iterator();
        while (j.hasNext()) {
            MavenProject moduleProject = (MavenProject)j.next();
            this.getLogger().info("Processing sources for module project: " + moduleProject.getId());
            Iterator fsIterator = fileSets.iterator();
            while (fsIterator.hasNext()) {
                FileSet fileSet = (FileSet)fsIterator.next();
                FileSet moduleFileSet = this.createFileSet(fileSet, sources, moduleProject);
                AddFileSetsTask task = new AddFileSetsTask(Collections.singletonList(moduleFileSet));
                task.setProject(moduleProject);
                task.setLogger(this.getLogger());
                task.execute(archiver, configSource);
            }
        }
    }

    protected boolean isDeprecatedModuleSourcesConfigPresent(ModuleSources sources) {
        boolean result = false;
        if (sources.getOutputDirectory() != null) {
            result = true;
        } else if (sources.getIncludes() != null && !sources.getIncludes().isEmpty()) {
            result = true;
        } else if (sources.getExcludes() != null && !sources.getExcludes().isEmpty()) {
            result = true;
        }
        if (result) {
            this.getLogger().warn("[DEPRECATION] Use of <moduleSources/> as a file-set is deprecated. Please use the <fileSets/> sub-element of <moduleSources/> instead.");
        } else if (!sources.isUseDefaultExcludes()) {
            this.getLogger().warn("[DEPRECATION] Use of directoryMode, fileMode, or useDefaultExcludes elements directly within <moduleSources/> are all deprecated. Please use the <fileSets/> sub-element of <moduleSources/> instead.");
        }
        return result;
    }

    protected FileSet createFileSet(FileSet fileSet, ModuleSources sources, MavenProject moduleProject) throws AssemblyFormattingException {
        String destPath;
        FileSet fs = new FileSet();
        String sourcePath = fileSet.getDirectory();
        File moduleBasedir = moduleProject.getBasedir();
        if (sourcePath != null) {
            File sourceDir = new File(sourcePath);
            if (!sourceDir.isAbsolute()) {
                sourcePath = new File(moduleBasedir, sourcePath).getAbsolutePath();
            }
        } else {
            sourcePath = moduleBasedir.getAbsolutePath();
        }
        fs.setDirectory(sourcePath);
        fs.setDirectoryMode(fileSet.getDirectoryMode());
        ArrayList<String> excludes = new ArrayList<String>();
        List originalExcludes = fileSet.getExcludes();
        if (originalExcludes != null && !originalExcludes.isEmpty()) {
            excludes.addAll(originalExcludes);
        }
        if (sources.isExcludeSubModuleDirectories()) {
            List modules = moduleProject.getModules();
            Iterator moduleIterator = modules.iterator();
            while (moduleIterator.hasNext()) {
                String moduleSubPath = (String)moduleIterator.next();
                excludes.add(moduleSubPath + "/**");
            }
        }
        fs.setExcludes(excludes);
        fs.setFileMode(fileSet.getFileMode());
        fs.setIncludes(fileSet.getIncludes());
        fs.setLineEnding(fileSet.getLineEnding());
        String destPathPrefix = "";
        if (sources.isIncludeModuleDirectory() && !(destPathPrefix = AssemblyFormatUtils.evaluateFileNameMapping(sources.getOutputDirectoryMapping(), moduleProject.getArtifact())).endsWith("/")) {
            destPathPrefix = destPathPrefix + "/";
        }
        destPath = (destPath = fileSet.getOutputDirectory()) == null ? destPathPrefix : destPathPrefix + destPath;
        destPath = AssemblyFormatUtils.getOutputDirectory(destPath, moduleProject, "");
        fs.setOutputDirectory(destPath);
        this.getLogger().debug("module source directory is: " + sourcePath);
        this.getLogger().debug("module dest directory is: " + destPath + " (assembly basedir may be prepended)");
        return fs;
    }

    protected Set getModuleProjects(ModuleSet moduleSet, AssemblerConfigurationSource configSource, boolean includeSubModules) throws ArchiveCreationException {
        Set moduleProjects;
        MavenProject project = configSource.getProject();
        try {
            moduleProjects = ProjectUtils.getProjectModules(project, configSource.getReactorProjects(), includeSubModules, this.getLogger());
        }
        catch (IOException e) {
            throw new ArchiveCreationException("Error retrieving module-set for project: " + project.getId() + ": " + e.getMessage(), e);
        }
        FilterUtils.filterProjects(moduleProjects, moduleSet.getIncludes(), moduleSet.getExcludes(), true, this.getLogger());
        return moduleProjects;
    }
}

