/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderers.ajax;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIParameter;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.ajax4jsf.framework.renderer.RendererBase;
import org.ajax4jsf.framework.renderer.RendererUtils;
import org.ajax4jsf.framework.util.javascript.JSFunction;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandLinkRenderer
extends RendererBase {
    private static final Log _log = LogFactory.getLog((Class)CommandLinkRenderer.class);
    private static final String[] LINK_EXCLUSIONS = new String[]{"onclick", "target", "href"};

    protected void doDecode(FacesContext context, UIComponent component) {
        UIForm form = this.getUtils().getNestingForm(context, component);
        if (null != form) {
            String hiddenFieldId = form.getClientId(context) + ":_idcl";
            Object hiddenFieldValue = context.getExternalContext().getRequestParameterMap().get(hiddenFieldId);
            if (null != hiddenFieldValue && component.getClientId(context).equals(hiddenFieldValue)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)Messages.getMessage(Messages.COMMAND_LINK_SUBMIT_INFO, component.getClientId(context)));
                }
                ActionEvent actionEvent = new ActionEvent(component);
                component.queueEvent((FacesEvent)actionEvent);
            }
        }
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        if (this.isDisabled(context, component)) {
            this.doEncodePassiveBegin(writer, context, component);
        } else {
            this.doEncodeActiveBegin(writer, context, component);
        }
    }

    protected void doEncodeActiveBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        writer.startElement("a", component);
        this.getUtils().encodeId(context, component);
        this.getUtils().encodeAttributesFromArray(context, component, RendererUtils.HTML.PASS_THRU_STYLES);
        this.getUtils().encodePassThruWithExclusionsArray(context, component, LINK_EXCLUSIONS);
        writer.writeAttribute("href", (Object)"#", null);
        UIForm form = this.getUtils().getNestingForm(context, component);
        String clientId = component.getClientId(context);
        if (null == form) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)Messages.getMessage(Messages.COMMAND_LINK_NOT_IN_FORM_WARNING, clientId));
            }
            return;
        }
        Object click = component.getAttributes().get("onclick");
        StringBuffer onclick = new StringBuffer(256);
        if (null != click) {
            onclick.append(click).append(';');
        }
        JSFunction submit = new JSFunction("_JSFFormSubmit");
        submit.addParameter(clientId);
        submit.addParameter(form.getClientId(context));
        submit.addParameter(component.getAttributes().get("target"));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Iterator iter = component.getChildren().iterator();
        while (iter.hasNext()) {
            Object child = iter.next();
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            parameters.put(param.getName(), param.getValue());
        }
        submit.addParameter(parameters);
        onclick.append("return ");
        submit.appendScript(onclick);
        writer.writeAttribute("onclick", (Object)onclick, "onclick");
        this.encodeValue(writer, context, component);
    }

    protected void doEncodePassiveBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        writer.startElement("span", component);
        this.getUtils().encodeId(context, component);
        this.getUtils().encodeAttributesFromArray(context, component, RendererUtils.HTML.PASS_THRU_STYLES);
        this.getUtils().encodePassThru(context, component);
        this.encodeValue(writer, context, component);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.renderChildren(context, component);
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        if (this.isDisabled(context, component)) {
            this.doEncodePassiveEnd(writer, context, component);
        } else {
            this.doEncodeActiveEnd(writer, context, component);
        }
    }

    protected void doEncodeActiveEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        writer.endElement("a");
    }

    protected void doEncodePassiveEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        writer.endElement("span");
    }

    private boolean isDisabled(FacesContext context, UIComponent command) {
        return command.getAttributes().get("disabled") != null && command.getAttributes().get("disabled").equals(Boolean.TRUE);
    }

    protected Class getComponentClass() {
        return UICommand.class;
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeValue(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        Object value;
        String valueString = null;
        if (component instanceof UICommand) {
            Object value2 = ((UICommand)component).getValue();
            if (value2 != null) {
                valueString = value2.toString();
            }
        } else if (component instanceof ValueHolder && (value = ((ValueHolder)component).getValue()) != null) {
            valueString = this.getUtils().formatValue(context, component, value);
        }
        if (null != valueString && valueString.length() > 0) {
            writer.write(valueString);
        }
    }
}

