/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderers.ajax;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.ajax.UIAjaxOutputPanel;
import org.ajax4jsf.framework.ajax.AjaxContext;
import org.ajax4jsf.framework.renderer.RendererBase;

public class AjaxOutputPanelRenderer
extends RendererBase {
    private final String[] STYLE_ATTRIBUTES = new String[]{"style", "class"};

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        UIAjaxOutputPanel panel = (UIAjaxOutputPanel)component;
        if ("none".equals(panel.getLayout())) {
            if (component.getChildCount() > 0) {
                AjaxContext ajaxContext = AjaxContext.getCurrentInstance(context);
                boolean ajaxRequest = ajaxContext.isAjaxRequest();
                Set ajaxRenderedAreas = ajaxContext.getAjaxRenderedAreas();
                Iterator it = component.getChildren().iterator();
                while (it.hasNext()) {
                    UIComponent child = (UIComponent)it.next();
                    String childId = child.getClientId(context);
                    if (child.isRendered()) {
                        ResponseWriter out = context.getResponseWriter();
                        out.startElement("span", child);
                        out.writeAttribute("id", (Object)childId, "id");
                        out.writeAttribute("style", (Object)"display: none;", "style");
                        out.endElement("span");
                    } else {
                        this.renderChild(context, child);
                    }
                    if (!ajaxRequest || null == ajaxRenderedAreas) continue;
                    ajaxRenderedAreas.add(childId);
                }
            }
        } else {
            this.renderChildren(context, component);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected Class getComponentClass() {
        return UIAjaxOutputPanel.class;
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIAjaxOutputPanel panel = (UIAjaxOutputPanel)component;
        if (!"none".equals(panel.getLayout())) {
            writer.startElement(this.getTag(panel), (UIComponent)panel);
            this.getUtils().encodeId(context, component);
            this.getUtils().encodePassThru(context, component);
            this.getUtils().encodeAttributesFromArray(context, component, this.STYLE_ATTRIBUTES);
        }
    }

    private String getTag(UIAjaxOutputPanel panel) {
        return "block".equals(panel.getLayout()) ? "div" : "span";
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIAjaxOutputPanel panel = (UIAjaxOutputPanel)component;
        if (!"none".equals(panel.getLayout())) {
            writer.endElement(this.getTag(panel));
        }
        if (panel.isKeepTransient()) {
            this.markNoTransient(component);
        }
    }

    private void markNoTransient(UIComponent component) {
        Iterator iter = component.getFacetsAndChildren();
        while (iter.hasNext()) {
            UIComponent element = (UIComponent)iter.next();
            this.markNoTransient(element);
            element.setTransient(false);
        }
    }
}

