/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.util.image;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import org.ajax4jsf.framework.util.image.ImageFilterOp;
import org.ajax4jsf.framework.util.image.ImageGenerator;
import org.ajax4jsf.framework.util.image.Quantize;
import org.ajax4jsf.framework.util.message.Messages;

public class ImageWrapper {
    protected Image image;
    protected int width;
    protected int height;
    protected ImageGenerator generator;
    private Graphics2D graphics;

    public ImageWrapper(Image image, int width, int height, ImageGenerator generator) {
        this.image = image;
        this.width = width;
        this.height = height;
        this.generator = generator;
        this.graphics = null;
    }

    public ImageWrapper(Image image, ImageGenerator generator) {
        this(image, image.getWidth(null), image.getHeight(null), generator);
    }

    public BufferedImage getBufferedImage() {
        if (!(this.image instanceof BufferedImage)) {
            BufferedImage buffered = new BufferedImage(this.width, this.height, 2);
            buffered.createGraphics().drawImage(this.image, 0, 0, null);
            this.setImage(buffered);
        }
        return (BufferedImage)this.image;
    }

    public Graphics getGraphics() {
        if (this.graphics == null) {
            BufferedImage img = this.getBufferedImage();
            this.graphics = img.createGraphics();
        }
        return this.graphics;
    }

    protected void setImage(Image image) {
        this.image = image;
        this.graphics = null;
    }

    public Object clone() {
        ImageWrapper wrapper = this.generator.createImage(this.width, this.height);
        wrapper.getGraphics().drawImage(this.image, 0, 0, null);
        return wrapper;
    }

    public Image getImage() {
        return this.image;
    }

    public ImageProducer getSource() {
        return this.image.getSource();
    }

    public void dispose() {
        this.image = null;
        if (this.graphics != null) {
            this.graphics.dispose();
            this.graphics = null;
        }
    }

    public void setFont(String name, int style, int size) {
        this.getGraphics().setFont(new Font(name, style, size));
    }

    public void setColor(int red, int green, int blue) {
        this.getGraphics().setColor(new Color(red, green, blue));
    }

    public void setColor(int color) {
        this.getGraphics().setColor(new Color(color));
    }

    public void setColor(Color color) {
        this.getGraphics().setColor(color);
    }

    public void setColor(String color) {
        this.getGraphics().setColor(Color.decode(color));
    }

    public void drawString(String str, int x, int y) {
        this.getGraphics().drawString(str, x, y);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.getGraphics().drawLine(x1, y1, x2, y2);
    }

    public void drawRect(int x, int y, int w, int h) {
        this.getGraphics().drawRect(x, y, w, h);
    }

    public void drawImage(String filename, int x, int y) throws IOException {
        Image img = this.generator.read(filename);
        if (img != null) {
            this.getGraphics().drawImage(img, x, y, null);
        }
    }

    public void drawImage(ImageWrapper image, int x, int y) throws IOException {
        this.getGraphics().drawImage(image.getImage(), x, y, null);
    }

    public void fillRect(int x, int y, int w, int h) {
        this.getGraphics().fillRect(x, y, w, h);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void crop(int x, int y, int w, int h) {
        if (this.image instanceof BufferedImage) {
            this.setImage(((BufferedImage)this.image).getSubimage(x, y, w, h));
        } else {
            BufferedImage buffered = new BufferedImage(w, h, 2);
            Graphics2D g2d = buffered.createGraphics();
            g2d.drawImage(this.image, -x, -y, null);
            g2d.dispose();
            this.setImage(buffered);
        }
    }

    protected BufferedImage resize(int w, int h, boolean smooth) {
        BufferedImage buffered = new BufferedImage(w, h, 2);
        Graphics2D g2d = buffered.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, smooth ? RenderingHints.VALUE_INTERPOLATION_BICUBIC : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, smooth ? RenderingHints.VALUE_RENDER_QUALITY : RenderingHints.VALUE_RENDER_SPEED);
        AffineTransform at = AffineTransform.getScaleInstance((double)w / (double)this.width, (double)h / (double)this.height);
        g2d.drawImage(this.image, at, null);
        g2d.dispose();
        return buffered;
    }

    public void resize(int w, int h) {
        double factor = Math.max((double)w / (double)this.width, (double)h / (double)this.height);
        if (factor > 1.0) {
            this.setImage(this.resize(w, h, true));
        } else {
            ImageFilterOp filter = new ImageFilterOp(new AreaAveragingScaleFilter(w, h));
            this.setImage(filter.filter(this.getBufferedImage(), null));
        }
        this.width = w;
        this.height = h;
    }

    public void resizeFast(int w, int h) {
        this.image = this.resize(w, h, false);
        this.width = w;
        this.height = h;
    }

    public void reduceColors(int colors) {
        this.reduceColors(colors, false);
    }

    public void reduceColors(int colors, boolean dither) {
        this.reduceColors(colors, dither, true);
    }

    public void reduceColors(int colors, boolean dither, boolean alphaToBitmask) {
        this.setImage(Quantize.process(this.getBufferedImage(), colors, dither, alphaToBitmask));
    }

    public void saveAs(String filename) throws IOException {
        this.saveAs(filename, -1.0f, false);
    }

    public void saveAs(String filename, float quality) throws IOException {
        this.saveAs(filename, quality, false);
    }

    public void saveAs(String filename, float quality, boolean alpha) throws IOException {
        this.generator.write(this, filename, quality, alpha);
    }

    public void setTransparentPixel(int trans) {
        BufferedImage bi = this.getBufferedImage();
        ColorModel cm = bi.getColorModel();
        if (!(cm instanceof IndexColorModel)) {
            throw new RuntimeException(Messages.getMessage(Messages.NOT_INDEXED_IMAGE_ERROR));
        }
        IndexColorModel icm = (IndexColorModel)cm;
        int mapSize = icm.getMapSize();
        byte[] reds = new byte[mapSize];
        byte[] greens = new byte[mapSize];
        byte[] blues = new byte[mapSize];
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        icm = new IndexColorModel(icm.getPixelSize(), mapSize, reds, greens, blues, trans);
        this.setImage(new BufferedImage(icm, bi.getRaster(), false, null));
    }

    public int getPixel(int x, int y) {
        BufferedImage bi = this.getBufferedImage();
        if (bi.getColorModel() instanceof IndexColorModel) {
            return bi.getRaster().getSample(x, y, 0);
        }
        return bi.getRGB(x, y);
    }
}

