/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.skin;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;
import org.ajax4jsf.framework.skin.Skin;
import org.ajax4jsf.framework.skin.SkinFactory;
import org.ajax4jsf.framework.skin.SkinImpl;
import org.ajax4jsf.framework.skin.SkinNotFoundException;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SkinFactoryImpl
extends SkinFactory {
    public static final String RENDER_KIT_PARAMETER = "org.ajax4jsf.RENDERKIT_DEFINITION";
    private static final String DEFAULT_SKIN_PROPERTIES_RESOURCE = "META-INF/skins/DEFAULT.skin.properties";
    private static final String DEFAULT_CONFIGURATION_RESOURCE = "META-INF/skins/DEFAULT.configuration.properties";
    private static final String DEFAULT_SKIN_NAME = "DEFAULT";
    private static final String[] SKINS_PATHS = new String[]{"META-INF/skins/%s.skin.properties", "%s.skin.properties"};
    private static final String[] DEFAULT_SKIN_PATHS = new String[]{"META-INF/skins/DEFAULT.skin.properties"};
    private static final String[] CONFIGURATIONS_PATHS = new String[]{"META-INF/skins/%s.configuration.properties", "%s.configuration.properties"};
    private static final String[] DEFAULT_CONFIGURATION_PATHS = new String[]{"META-INF/skins/DEFAULT.configuration.properties"};
    private Map skins = Collections.synchronizedMap(new HashMap());
    private Properties defaultSkinProperties = null;
    private String skinName = null;
    private ValueBinding skinBinding = null;
    private static final Log log = LogFactory.getLog((Class)SkinFactoryImpl.class);

    public Skin getSkin(FacesContext context) {
        Object currentSkinOrName = this.getSkinOrName(context);
        if (null == currentSkinOrName) {
            throw new SkinNotFoundException(Messages.getMessage(Messages.NULL_SKIN_NAME_ERROR));
        }
        if (currentSkinOrName instanceof Skin) {
            return (Skin)currentSkinOrName;
        }
        String currentSkinName = currentSkinOrName.toString();
        Skin currentSkin = (Skin)this.skins.get(currentSkinName);
        if (currentSkin == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage(Messages.CREATE_SKIN_INFO, currentSkinName));
            }
            currentSkin = this.buildSkin(currentSkinName, this.getDefaultSkinProperties());
            this.skins.put(currentSkinName, currentSkin);
        }
        return currentSkin;
    }

    protected Properties getDefaultSkinProperties() {
        if (this.defaultSkinProperties == null) {
            this.defaultSkinProperties = this.loadDefaultProperties(DEFAULT_SKIN_PROPERTIES_RESOURCE);
        }
        return this.defaultSkinProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadDefaultProperties(String path) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Properties defaultProperties = new Properties();
        try {
            Enumeration<URL> properties = loader.getResources(path);
            while (properties.hasMoreElements()) {
                URL url = properties.nextElement();
                InputStream propertyStream = null;
                try {
                    propertyStream = url.openStream();
                    defaultProperties.load(propertyStream);
                }
                catch (IOException e) {
                    log.info((Object)Messages.getMessage(Messages.DEFAULT_PROPERTIES_NOT_FOUND_ERROR, path), (Throwable)e);
                }
                finally {
                    if (null == propertyStream) continue;
                    propertyStream.close();
                }
            }
        }
        catch (IOException e) {
            log.info((Object)Messages.getMessage(Messages.DEFAULT_PROPERTIES_NOT_FOUND_ERROR, path), (Throwable)e);
        }
        return defaultProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getSkinOrName(FacesContext context) {
        SkinFactoryImpl skinFactoryImpl = this;
        synchronized (skinFactoryImpl) {
            if (this.skinName == null && this.skinBinding == null) {
                String currentSkinName = context.getExternalContext().getInitParameter("org.ajax4jsf.SKIN");
                if (currentSkinName == null) {
                    return DEFAULT_SKIN_NAME;
                }
                if (SkinFactory.isValueReference(currentSkinName)) {
                    this.skinBinding = context.getApplication().createValueBinding(currentSkinName);
                } else {
                    this.skinName = currentSkinName;
                }
            }
        }
        if (this.skinBinding != null) {
            return this.skinBinding.getValue(context);
        }
        return this.skinName;
    }

    protected Skin buildSkin(String name, Properties defaultProperties) throws SkinNotFoundException {
        Map skinParams = this.loadProperties(name, defaultProperties, SKINS_PATHS);
        return new SkinImpl(skinParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map loadProperties(String name, Properties defaultProperties, String[] paths) throws SkinNotFoundException, FacesException, ReferenceSyntaxException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Properties skinProperties = new Properties(defaultProperties);
        int loadedPropertiesCount = 0;
        for (int i = 0; i < paths.length; ++i) {
            try {
                String skinPropertiesLocation = paths[i].replaceAll("%s", name);
                Enumeration<URL> properties = loader.getResources(skinPropertiesLocation);
                while (properties.hasMoreElements()) {
                    URL url = properties.nextElement();
                    InputStream propertyStream = null;
                    try {
                        propertyStream = url.openStream();
                        skinProperties.load(propertyStream);
                        ++loadedPropertiesCount;
                    }
                    catch (IOException e) {
                        log.warn((Object)Messages.getMessage(Messages.SKIN_PROPERTIES_IO_ERROR), (Throwable)e);
                    }
                    finally {
                        if (null == propertyStream) continue;
                        propertyStream.close();
                    }
                }
                continue;
            }
            catch (IOException e) {
                if (!log.isInfoEnabled()) continue;
                log.info((Object)Messages.getMessage(Messages.SKIN_PROPERTIES_IO_ERROR), (Throwable)e);
            }
        }
        if (loadedPropertiesCount == 0) {
            throw new SkinNotFoundException(Messages.getMessage(Messages.SKIN_NOT_FOUND_ERROR, name));
        }
        ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        Application app = factory.getApplication();
        HashMap<String, Object> skinParams = new HashMap<String, Object>();
        Enumeration<?> e = skinProperties.propertyNames();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            String property = skinProperties.getProperty(propertyName);
            if (null == property) continue;
            int count = 0;
            while (property.startsWith("&")) {
                if (null == (property = skinProperties.getProperty(property.substring(1)))) {
                    throw new FacesException(Messages.getMessage("SKIN_ILLEGAL_REFERENCE", propertyName));
                }
                if (count++ <= 1000) continue;
                throw new FacesException(Messages.getMessage("SKIN_CYCLIC_REFERENCE", propertyName));
            }
            if (SkinFactory.isValueReference(property)) {
                skinParams.put(propertyName, app.createValueBinding(property));
                continue;
            }
            skinParams.put(propertyName, property);
        }
        return skinParams;
    }
}

