/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.ajax.repeat;

import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import org.ajax4jsf.ajax.repeat.DataVisitor;
import org.ajax4jsf.ajax.repeat.ExtendedDataModel;
import org.ajax4jsf.ajax.repeat.Range;
import org.ajax4jsf.ajax.repeat.SequenceRange;

public class SequenceDataModel
extends ExtendedDataModel {
    DataModel wrapped;

    public SequenceDataModel(DataModel wrapped) {
        this.wrapped = wrapped;
    }

    public void walk(FacesContext context, DataVisitor visitor, Range range, Object argument) throws IOException {
        SequenceRange seqRange = (SequenceRange)range;
        int rows = seqRange.getRows();
        int rowCount = this.wrapped.getRowCount();
        int currentRow = seqRange.getFirstRow();
        if (rows > 0) {
            rows += currentRow;
            if (rowCount >= 0) {
                rows = Math.min(rows, rowCount);
            }
        } else {
            rows = rowCount >= 0 ? rowCount : -1;
        }
        while (rows < 0 || currentRow < rows) {
            this.wrapped.setRowIndex(currentRow);
            if (!this.wrapped.isRowAvailable()) break;
            visitor.process(context, new Integer(currentRow), argument);
            ++currentRow;
        }
    }

    public Object getRowKey() {
        int index = this.wrapped.getRowIndex();
        if (index < 0) {
            return null;
        }
        return new Integer(index);
    }

    public ExtendedDataModel getSerializableModel(Range range) {
        return null;
    }

    public void setRowKey(Object key) {
        if (null == key) {
            this.wrapped.setRowIndex(-1);
        } else {
            Integer index = (Integer)key;
            this.wrapped.setRowIndex(index.intValue());
        }
    }

    public int getRowCount() {
        return this.wrapped.getRowCount();
    }

    public Object getRowData() {
        return this.wrapped.getRowData();
    }

    public int getRowIndex() {
        return this.wrapped.getRowIndex();
    }

    public Object getWrappedData() {
        return this.wrapped.getWrappedData();
    }

    public boolean isRowAvailable() {
        return this.wrapped.isRowAvailable();
    }

    public void setRowIndex(int rowIndex) {
        this.wrapped.setRowIndex(rowIndex);
    }

    public void setWrappedData(Object data) {
        this.wrapped.setWrappedData(data);
    }
}

