/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import net.dongliu.requests.RequestBuilder;
import net.dongliu.requests.exception.InvalidUrlException;
import net.dongliu.requests.struct.Method;
import org.apache.http.client.CookieStore;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCookieStore;

public class Session {
    private final HttpClientContext context = HttpClientContext.create();

    Session() {
        BasicCookieStore cookieStore = new BasicCookieStore();
        this.context.setCookieStore((CookieStore)cookieStore);
    }

    HttpClientContext getContext() {
        return this.context;
    }

    public RequestBuilder get(String url) throws InvalidUrlException {
        return this.newBuilder(url).method(Method.GET);
    }

    public RequestBuilder head(String url) throws InvalidUrlException {
        return this.newBuilder(url).method(Method.HEAD);
    }

    public RequestBuilder post(String url) throws InvalidUrlException {
        return this.newBuilder(url).method(Method.POST);
    }

    public RequestBuilder put(String url) throws InvalidUrlException {
        return this.newBuilder(url).method(Method.PUT);
    }

    public RequestBuilder delete(String url) throws InvalidUrlException {
        return this.newBuilder(url).method(Method.DELETE);
    }

    public RequestBuilder options(String url) throws InvalidUrlException {
        return this.newBuilder(url).method(Method.OPTIONS);
    }

    public RequestBuilder patch(String url) throws InvalidUrlException {
        return this.newBuilder(url).method(Method.PATCH);
    }

    public RequestBuilder trace(String url) throws InvalidUrlException {
        return this.newBuilder(url).method(Method.TRACE);
    }

    private RequestBuilder newBuilder(String url) throws InvalidUrlException {
        return new RequestBuilder().session(this).url(url);
    }
}

