/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.dongliu.requests.ConnectionManagerWrapper;
import net.dongliu.requests.Utils;
import net.dongliu.requests.struct.Host;
import net.dongliu.requests.struct.Pair;
import net.dongliu.requests.struct.Proxy;
import org.apache.http.HttpHost;
import org.apache.http.config.Registry;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class ConnectionPool
implements Closeable {
    private final PoolingHttpClientConnectionManager manager;
    private final Proxy proxy;

    public ConnectionPool(PoolingHttpClientConnectionManager manager, Proxy proxy) {
        this.manager = manager;
        this.proxy = proxy;
    }

    public static ConnectionPoolBuilder custom() {
        return new ConnectionPoolBuilder();
    }

    @Override
    public void close() throws IOException {
        this.manager.close();
    }

    Proxy getProxy() {
        return this.proxy;
    }

    HttpClientConnectionManager wrappedConnectionManager() {
        return new ConnectionManagerWrapper((HttpClientConnectionManager)this.manager);
    }

    public static class ConnectionPoolBuilder {
        private long timeToLive = -1L;
        private int maxTotal = 20;
        private int maxPerRoute = 2;
        private List<Pair<Host, Integer>> perRouteCount;
        private boolean verify = true;
        private Proxy proxy;

        ConnectionPoolBuilder() {
        }

        public ConnectionPool build() {
            Registry<ConnectionSocketFactory> r = Utils.getConnectionSocketFactoryRegistry(this.proxy, this.verify);
            PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager(r, null, null, null, this.timeToLive, TimeUnit.MILLISECONDS);
            manager.setMaxTotal(this.maxTotal);
            manager.setDefaultMaxPerRoute(this.maxPerRoute);
            if (this.perRouteCount != null) {
                for (Pair<Host, Integer> pair : this.perRouteCount) {
                    Host host = pair.getName();
                    manager.setMaxPerRoute(new HttpRoute(new HttpHost(host.getDomain(), host.getPort())), pair.getValue().intValue());
                }
            }
            return new ConnectionPool(manager, this.proxy);
        }

        public ConnectionPoolBuilder timeToLive(long timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public ConnectionPoolBuilder maxTotal(int maxTotal) {
            this.maxTotal = maxTotal;
            return this;
        }

        public ConnectionPoolBuilder maxPerRoute(int maxPerRoute) {
            this.maxPerRoute = maxPerRoute;
            return this;
        }

        public ConnectionPoolBuilder maxPerRoute(Host host, int maxPerRoute) {
            this.ensurePerRouteCount();
            this.perRouteCount.add(new Pair<Host, Integer>(host, maxPerRoute));
            return this;
        }

        public ConnectionPoolBuilder verify(boolean verify) {
            this.verify = verify;
            return this;
        }

        private void ensurePerRouteCount() {
            if (this.perRouteCount == null) {
                this.perRouteCount = new ArrayList<Pair<Host, Integer>>();
            }
        }

        private ConnectionPoolBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }
    }
}

