/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.csv;

import com.univocity.parsers.common.AbstractWriter;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.Writer;

public class CsvWriter
extends AbstractWriter<CsvWriterSettings> {
    private final char separator;
    private final char quotechar;
    private final char escapechar;
    private final boolean ignoreLeading;
    private final boolean ignoreTrailing;
    private final boolean quoteAllFields;
    private final char newLine;

    public CsvWriter(Writer writer, CsvWriterSettings settings) {
        super(writer, settings);
        CsvFormat format = (CsvFormat)settings.getFormat();
        this.separator = format.getDelimiter();
        this.quotechar = format.getQuote();
        this.escapechar = format.getQuoteEscape();
        this.newLine = format.getNormalizedNewline();
        this.quoteAllFields = settings.getQuoteAllFields();
        this.ignoreLeading = settings.getIgnoreLeadingWhitespaces();
        this.ignoreTrailing = settings.getIgnoreTrailingWhitespaces();
    }

    @Override
    protected void processRow(Object[] row) {
        for (int i = 0; i < row.length; ++i) {
            String nextElement;
            boolean isElementQuoted;
            if (i != 0) {
                this.appendToRow(this.separator);
            }
            if (isElementQuoted = this.quoteElement(nextElement = this.getStringValue(row[i]))) {
                this.appender.append(this.quotechar);
            }
            int originalLength = this.appender.length();
            this.append(isElementQuoted, nextElement);
            if (this.appender.length() == originalLength && this.nullValue != null && !this.nullValue.isEmpty()) {
                if (isElementQuoted) {
                    this.append(true, this.emptyValue);
                } else {
                    this.append(false, this.nullValue);
                }
            }
            if (isElementQuoted) {
                this.appendValueToRow();
                this.appendToRow(this.quotechar);
                continue;
            }
            this.appendValueToRow();
        }
    }

    private boolean quoteElement(String nextElement) {
        if (this.quoteAllFields) {
            return true;
        }
        if (nextElement == null) {
            return false;
        }
        for (int j = 0; j < nextElement.length(); ++j) {
            char nextChar = nextElement.charAt(j);
            if (nextChar != this.separator && nextChar != this.newLine) continue;
            return true;
        }
        return false;
    }

    private void append(boolean isElementQuoted, String element) {
        if (element == null) {
            element = this.nullValue;
        }
        if (element == null) {
            return;
        }
        int start = 0;
        if (this.ignoreLeading) {
            start = this.skipLeadingWhitespace(element);
        }
        if (this.ignoreTrailing) {
            for (int i = start; i < element.length(); ++i) {
                char nextChar = element.charAt(i);
                if (isElementQuoted && nextChar == this.quotechar) {
                    this.appender.appendIgnoringWhitespace(this.escapechar);
                }
                this.appender.appendIgnoringWhitespace(nextChar);
            }
        } else {
            for (int i = start; i < element.length(); ++i) {
                char nextChar = element.charAt(i);
                if (isElementQuoted && nextChar == this.quotechar) {
                    this.appender.append(this.escapechar);
                }
                this.appender.append(nextChar);
            }
        }
    }
}

