/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.annotations.helpers;

import com.univocity.parsers.annotations.Parsed;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class FieldMapping {
    private final Field field;
    private int index;
    private String fieldName;
    private final Class<?> beanClass;
    private final Method readMethod;
    private final Method writeMethod;
    private boolean accessible = false;

    public FieldMapping(Class<?> beanClass, Field field, PropertyDescriptor property) {
        this.beanClass = beanClass;
        this.field = field;
        this.readMethod = property != null ? property.getReadMethod() : null;
        this.writeMethod = property != null ? property.getWriteMethod() : null;
        this.determineFieldMapping();
    }

    private void determineFieldMapping() {
        Parsed parsed = this.field.getAnnotation(Parsed.class);
        this.index = parsed.index();
        if (this.index >= 0) {
            this.fieldName = null;
            return;
        }
        String name = parsed.field();
        if (name.isEmpty()) {
            name = this.field.getName();
        }
        this.fieldName = name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        result = 31 * result + this.index;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        FieldMapping other = (FieldMapping)obj;
        if (this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName)) {
            return false;
        }
        return this.index == other.index;
    }

    public boolean isMappedToIndex() {
        return this.index >= 0;
    }

    public boolean isMappedToField() {
        return this.index < 0;
    }

    public int getIndex() {
        return this.index;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    private void setAccessible(Method accessor) {
        if (accessor == null && !this.accessible) {
            this.field.setAccessible(true);
            this.accessible = true;
        }
    }

    public Object read(Object instance) {
        this.setAccessible(this.readMethod);
        try {
            if (this.readMethod != null) {
                return this.readMethod.invoke(instance, new Object[0]);
            }
            return this.field.get(instance);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unable to get value from field " + this.field.getName() + "' in " + this.beanClass.getName());
        }
    }

    public void write(Object instance, Object value) {
        this.setAccessible(this.writeMethod);
        try {
            if (this.writeMethod != null) {
                this.writeMethod.invoke(instance, value);
            } else {
                this.field.set(instance, value);
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unable to set value '" + value + "' for field " + this.field.getName() + "' in " + this.beanClass.getName());
        }
    }
}

