/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.util.Util;
import sun.misc.Unsafe;

public class Sequence {
    private static final Unsafe unsafe = Util.getUnsafe();
    private static final long valueOffset;
    private final long[] paddedValue = new long[15];

    public Sequence() {
        this.setOrdered(-1L);
    }

    public Sequence(long initialValue) {
        this.setOrdered(initialValue);
    }

    public long get() {
        return unsafe.getLongVolatile(this.paddedValue, valueOffset);
    }

    public void set(long value) {
        unsafe.putOrderedLong(this.paddedValue, valueOffset, value);
    }

    private void setOrdered(long value) {
        unsafe.putOrderedLong(this.paddedValue, valueOffset, value);
    }

    public boolean compareAndSet(long expectedValue, long newValue) {
        return unsafe.compareAndSwapLong(this.paddedValue, valueOffset, expectedValue, newValue);
    }

    public String toString() {
        return Long.toString(this.get());
    }

    public long incrementAndGet() {
        return this.addAndGet(1L);
    }

    public long addAndGet(long increment) {
        long newValue;
        long currentValue;
        while (!this.compareAndSet(currentValue = this.get(), newValue = currentValue + increment)) {
        }
        return newValue;
    }

    static {
        int base = unsafe.arrayBaseOffset(long[].class);
        int scale = unsafe.arrayIndexScale(long[].class);
        valueOffset = base + scale * 7;
    }
}

