/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import java.util.concurrent.TimeUnit;

final class ProcessingSequenceBarrier
implements SequenceBarrier {
    private final WaitStrategy waitStrategy;
    private final Sequence cursorSequence;
    private final Sequence[] dependentSequences;
    private volatile boolean alerted = false;

    public ProcessingSequenceBarrier(WaitStrategy waitStrategy, Sequence cursorSequence, Sequence[] dependentSequences) {
        this.waitStrategy = waitStrategy;
        this.cursorSequence = cursorSequence;
        this.dependentSequences = dependentSequences;
    }

    @Override
    public long waitFor(long sequence) throws AlertException, InterruptedException {
        this.checkAlert();
        return this.waitStrategy.waitFor(sequence, this.cursorSequence, this.dependentSequences, this);
    }

    @Override
    public long waitFor(long sequence, long timeout, TimeUnit units) throws AlertException, InterruptedException {
        this.checkAlert();
        return this.waitStrategy.waitFor(sequence, this.cursorSequence, this.dependentSequences, this, timeout, units);
    }

    @Override
    public long getCursor() {
        return this.cursorSequence.get();
    }

    @Override
    public boolean isAlerted() {
        return this.alerted;
    }

    @Override
    public void alert() {
        this.alerted = true;
        this.waitStrategy.signalAllWhenBlocking();
    }

    @Override
    public void clearAlert() {
        this.alerted = false;
    }

    @Override
    public void checkAlert() throws AlertException {
        if (this.alerted) {
            throw AlertException.INSTANCE;
        }
    }
}

