/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.tail.index;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.trie4j.tail.index.ArrayTailIndex;
import org.trie4j.tail.index.TailIndex;
import org.trie4j.tail.index.TailIndexBuilder;

public class ArrayTailIndexBuilder
implements Externalizable,
TailIndexBuilder {
    private int[] tail = new int[0];
    private int size;

    public ArrayTailIndexBuilder() {
    }

    public ArrayTailIndexBuilder(int initialCapacity) {
        this.tail = new int[initialCapacity];
        Arrays.fill(this.tail, -1);
    }

    @Override
    public void add(int nodeId, int start, int end) {
        this.ensureCapacity(nodeId);
        this.tail[nodeId] = start;
    }

    @Override
    public void addEmpty(int nodeId) {
        this.ensureCapacity(nodeId);
        this.tail[nodeId] = -1;
    }

    @Override
    public TailIndex build() {
        this.trimToSize();
        return new ArrayTailIndex(this.tail);
    }

    @Override
    public void trimToSize() {
        this.tail = Arrays.copyOf(this.tail, this.size);
    }

    private void ensureCapacity(int nodeId) {
        if (nodeId < this.size) {
            return;
        }
        if (nodeId >= this.tail.length) {
            this.tail = Arrays.copyOf(this.tail, (int)((double)(nodeId + 1) * 1.2));
            Arrays.fill(this.tail, this.size, this.tail.length, -1);
        }
        this.size = nodeId + 1;
    }

    @Override
    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        this.size = in.readInt();
        this.tail = (int[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.trimToSize();
        out.writeInt(this.size);
        out.writeObject(this.tail);
    }
}

