/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.tail;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.trie4j.tail.TailArray;
import org.trie4j.tail.TailCharIterator;
import org.trie4j.tail.TailUtil;
import org.trie4j.tail.index.TailIndex;

public class DefaultTailArray
implements Externalizable,
TailArray {
    private CharSequence tail;
    private TailIndex tailIndex;

    public DefaultTailArray() {
    }

    public DefaultTailArray(CharSequence tail, TailIndex tailIndex) {
        this.tail = tail;
        this.tailIndex = tailIndex;
    }

    public CharSequence getTail() {
        return this.tail;
    }

    public TailIndex getTailIndex() {
        return this.tailIndex;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tail = (CharSequence)in.readObject();
        this.tailIndex = (TailIndex)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.tail);
        out.writeObject(this.tailIndex);
    }

    @Override
    public TailCharIterator newIterator(int offset) {
        return new TailCharIterator(this.tail, offset);
    }

    @Override
    public TailCharIterator newIterator() {
        return new TailCharIterator(this.tail, -1);
    }

    @Override
    public int getIteratorOffset(int nodeId) {
        if (this.tailIndex.size() <= nodeId) {
            return -1;
        }
        return this.tailIndex.get(nodeId);
    }

    @Override
    public void getChars(StringBuilder builder, int nodeId) {
        if (this.tailIndex.size() <= nodeId) {
            return;
        }
        int offset = this.tailIndex.get(nodeId);
        if (offset == -1) {
            return;
        }
        TailUtil.appendChars(this.tail, offset, builder);
    }
}

