/*
 * Decompiled with CFR 0.152.
 */
package com.droidkit.actors.tasks;

import com.droidkit.actors.Actor;
import com.droidkit.actors.ActorRef;
import com.droidkit.actors.messages.PoisonPill;
import com.droidkit.actors.tasks.messages.TaskCancel;
import com.droidkit.actors.tasks.messages.TaskError;
import com.droidkit.actors.tasks.messages.TaskRequest;
import com.droidkit.actors.tasks.messages.TaskResult;
import java.util.HashSet;

public abstract class TaskActor<T>
extends Actor {
    private final HashSet<TaskListener> requests = new HashSet();
    private T result;
    private boolean isCompleted;
    private boolean isCompletedSuccess;
    private long dieTimeout = 300L;

    public void setTimeOut(long timeOut) {
        this.dieTimeout = timeOut;
    }

    @Override
    public void preStart() {
        this.startTask();
    }

    @Override
    public void onReceive(Object message) {
        if (message instanceof TaskRequest) {
            TaskRequest request = (TaskRequest)message;
            if (this.isCompleted) {
                if (this.isCompletedSuccess) {
                    this.reply(this.result);
                }
            } else {
                TaskListener listener = new TaskListener(request.getRequestId(), this.sender());
                this.requests.add(listener);
            }
        } else if (message instanceof TaskCancel) {
            if (this.isCompleted) {
                return;
            }
            TaskCancel cancel = (TaskCancel)message;
            TaskListener listener = new TaskListener(cancel.getRequestId(), this.sender());
            this.requests.remove(listener);
            if (this.requests.size() == 0) {
                this.onTaskObsolete();
                this.context().stopSelf();
            }
        } else if (message instanceof Result) {
            if (!this.isCompleted) {
                Result res = (Result)message;
                this.isCompleted = true;
                this.isCompletedSuccess = true;
                this.result = res.getRes();
                for (TaskListener request : this.requests) {
                    request.getSender().send(new TaskResult<T>(request.getRequestId(), this.result));
                }
                this.self().send((Object)PoisonPill.INSTANCE, this.dieTimeout);
            }
        } else if (message instanceof Error && !this.isCompleted) {
            this.isCompleted = true;
            Error error = (Error)message;
            for (TaskListener request : this.requests) {
                request.getSender().send(new TaskError(request.getRequestId(), error.getError()));
            }
            this.context().stopSelf();
        }
    }

    public abstract void startTask();

    public void onTaskObsolete() {
    }

    public void complete(T res) {
        this.self().send(new Result(res));
    }

    public void error(Throwable t) {
        this.self().send(new Error(t));
    }

    private static class TaskListener {
        private int requestId;
        private ActorRef sender;

        private TaskListener(int requestId, ActorRef sender) {
            this.requestId = requestId;
            this.sender = sender;
        }

        public int getRequestId() {
            return this.requestId;
        }

        public ActorRef getSender() {
            return this.sender;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskListener that = (TaskListener)o;
            if (this.requestId != that.requestId) {
                return false;
            }
            return this.sender.equals(that.sender);
        }

        public int hashCode() {
            int result = this.requestId;
            result = 31 * result + this.sender.hashCode();
            return result;
        }
    }

    private static class Result {
        private Object res;

        private Result(Object res) {
            this.res = res;
        }

        public Object getRes() {
            return this.res;
        }
    }

    private static class Error {
        private Throwable error;

        private Error(Throwable error) {
            this.error = error;
        }

        public Throwable getError() {
            return this.error;
        }
    }
}

