/*
 * Decompiled with CFR 0.152.
 */
package com.droidkit.actors.tasks;

import com.droidkit.actors.tasks.ActorAskImpl;
import com.droidkit.actors.tasks.AskCallback;
import com.droidkit.actors.tasks.AskCancelledException;
import com.droidkit.actors.tasks.AskTimeoutException;
import java.util.LinkedList;

public class AskFuture<T> {
    private LinkedList<AskCallback> callbacks = new LinkedList();
    private ActorAskImpl askImpl;
    private int reqId;
    private boolean isCompleted = false;
    private boolean isCanceled = false;
    private boolean isError = false;
    private T result = null;
    private Throwable error = null;

    AskFuture(ActorAskImpl askImpl, int reqId) {
        this.askImpl = askImpl;
        this.reqId = reqId;
    }

    public void addListener(AskCallback callback) {
        this.callbacks.add(callback);
    }

    public void removeListener(AskCallback callback) {
        this.callbacks.remove(callback);
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public boolean isError() {
        return this.isError;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public Throwable error() {
        return this.error;
    }

    public T result() {
        return this.result;
    }

    public void cancel() {
        if (this.isCompleted) {
            return;
        }
        this.isCompleted = true;
        this.isError = false;
        this.isCanceled = true;
        for (AskCallback callback : this.callbacks) {
            callback.onError(new AskCancelledException());
        }
        this.askImpl.onTaskCancelled(this.reqId);
    }

    void onError(Throwable throwable) {
        if (this.isCompleted) {
            return;
        }
        this.isCompleted = true;
        this.isCanceled = false;
        this.isError = true;
        this.error = throwable;
        this.result = null;
        for (AskCallback callback : this.callbacks) {
            callback.onError(throwable);
        }
    }

    void onResult(T res) {
        if (this.isCompleted) {
            return;
        }
        this.isCompleted = true;
        this.isCanceled = false;
        this.isError = false;
        this.error = null;
        this.result = res;
        for (AskCallback callback : this.callbacks) {
            callback.onResult(res);
        }
    }

    void onTimeout() {
        this.onError(new AskTimeoutException());
    }
}

