/*
 * Decompiled with CFR 0.152.
 */
package com.droidkit.actors.tasks;

import com.droidkit.actors.ActorRef;
import com.droidkit.actors.messages.DeadLetter;
import com.droidkit.actors.tasks.AskCallback;
import com.droidkit.actors.tasks.AskFuture;
import com.droidkit.actors.tasks.AskTimeoutException;
import com.droidkit.actors.tasks.messages.TaskCancel;
import com.droidkit.actors.tasks.messages.TaskError;
import com.droidkit.actors.tasks.messages.TaskRequest;
import com.droidkit.actors.tasks.messages.TaskResult;
import com.droidkit.actors.tasks.messages.TaskTimeout;
import java.util.HashMap;

public class ActorAskImpl {
    private HashMap<Integer, AskContainer> asks = new HashMap();
    private int nextReqId = 1;
    private ActorRef self;

    public ActorAskImpl(ActorRef self) {
        this.self = self;
    }

    public <T> AskFuture<T[]> combine(AskFuture ... futures) {
        final AskFuture<T[]> resultFuture = new AskFuture<T[]>(this, 0);
        final CombineContainer container = new CombineContainer(futures.length);
        int i = 0;
        while (i < futures.length) {
            final int index = i++;
            container.futures[index] = futures[index];
            container.callbacks[index] = new AskCallback(){

                public void onResult(Object result) {
                    container.completed[index] = true;
                    container.results[index] = result;
                    boolean isCompleted = true;
                    for (boolean c : container.completed) {
                        if (c) continue;
                        isCompleted = false;
                        break;
                    }
                    if (isCompleted && !container.isCompleted) {
                        container.isCompleted = true;
                        for (int i = 0; i < container.futures.length; ++i) {
                            container.futures[i].removeListener(container.callbacks[i]);
                        }
                        resultFuture.onResult(container.results);
                    }
                }

                @Override
                public void onError(Throwable throwable) {
                    if (!container.isCompleted) {
                        container.isCompleted = true;
                        for (int i = 0; i < container.futures.length; ++i) {
                            container.futures[i].removeListener(container.callbacks[i]);
                            container.futures[i].cancel();
                        }
                        resultFuture.onError(throwable);
                    }
                }
            };
            container.futures[index].addListener(container.callbacks[index]);
        }
        return resultFuture;
    }

    public <T> AskFuture<T> ask(ActorRef ref, long timeout, AskCallback<T> callback) {
        int reqId = this.nextReqId++;
        AskFuture future = new AskFuture(this, reqId);
        if (callback != null) {
            future.addListener(callback);
        }
        AskContainer container = new AskContainer(future, ref, reqId);
        this.asks.put(reqId, container);
        ref.send((Object)new TaskRequest(reqId), this.self);
        if (timeout > 0L) {
            this.self.send((Object)new TaskTimeout(reqId), timeout);
        }
        return future;
    }

    public boolean onTaskResult(TaskResult result) {
        AskContainer container = this.asks.remove(result.getRequestId());
        if (container != null) {
            container.future.onResult(result.getRes());
            return true;
        }
        return false;
    }

    public boolean onTaskError(TaskError error) {
        AskContainer container = this.asks.remove(error.getRequestId());
        if (container != null) {
            container.future.onError(error.getThrowable());
            return true;
        }
        return false;
    }

    public boolean onTaskTimeout(TaskTimeout taskTimeout) {
        AskContainer container = this.asks.remove(taskTimeout.getRequestId());
        if (container != null) {
            container.future.onTimeout();
            return true;
        }
        return false;
    }

    public boolean onTaskCancelled(int reqId) {
        AskContainer container = this.asks.remove(reqId);
        if (container != null) {
            container.ref.send((Object)new TaskCancel(reqId), this.self);
            return true;
        }
        return false;
    }

    public boolean onDeadLetter(DeadLetter letter) {
        TaskRequest request;
        AskContainer container;
        if (letter.getMessage() instanceof TaskRequest && (container = this.asks.remove((request = (TaskRequest)letter.getMessage()).getRequestId())) != null) {
            container.future.onError(new AskTimeoutException());
            return true;
        }
        return false;
    }

    private class CombineContainer {
        public boolean isCompleted = false;
        public Object[] results;
        public boolean[] completed;
        public AskFuture[] futures;
        public AskCallback[] callbacks;

        public CombineContainer(int count) {
            this.results = new Object[count];
            this.completed = new boolean[count];
            this.callbacks = new AskCallback[count];
            this.futures = new AskFuture[count];
        }
    }

    private class AskContainer {
        public final AskFuture future;
        public final ActorRef ref;
        public final int requestId;

        private AskContainer(AskFuture future, ActorRef ref, int requestId) {
            this.future = future;
            this.ref = ref;
            this.requestId = requestId;
        }
    }
}

