/*
 * Decompiled with CFR 0.152.
 */
package com.droidkit.actors.mailbox;

import com.droidkit.actors.dispatch.AbstractDispatchQueue;
import com.droidkit.actors.mailbox.Envelope;
import com.droidkit.actors.mailbox.Mailbox;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

public class MailboxesQueue
extends AbstractDispatchQueue<Envelope> {
    private static final long MULTIPLE = 10000L;
    private final TreeMap<Long, Long> timeShift = new TreeMap();
    private final TreeMap<Long, Envelope> envelopes = new TreeMap();
    private final HashSet<Mailbox> blocked = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockMailbox(Mailbox mailbox) {
        HashSet<Mailbox> hashSet = this.blocked;
        synchronized (hashSet) {
            this.blocked.add(mailbox);
        }
        this.notifyQueueChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockMailbox(Mailbox mailbox) {
        HashSet<Mailbox> hashSet = this.blocked;
        synchronized (hashSet) {
            this.blocked.remove(mailbox);
        }
        this.notifyQueueChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sendEnvelope(Envelope envelope, long time) {
        long shift = 0L;
        TreeMap<Long, Envelope> treeMap = this.envelopes;
        synchronized (treeMap) {
            if (this.timeShift.containsKey(time)) {
                shift = this.timeShift.get(time);
            }
            while (this.envelopes.containsKey(time * 10000L + shift)) {
                ++shift;
            }
            if (shift != 0L) {
                this.timeShift.put(time, shift);
            }
            this.envelopes.put(time * 10000L + shift, envelope);
        }
        this.notifyQueueChanged();
        return time * 10000L + shift;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEnvelope(long id) {
        TreeMap<Long, Envelope> treeMap = this.envelopes;
        synchronized (treeMap) {
            this.envelopes.remove(id);
        }
        this.notifyQueueChanged();
    }

    private Map.Entry<Long, Envelope> firstEnvelope() {
        for (Map.Entry<Long, Envelope> entry : this.envelopes.entrySet()) {
            if (this.blocked.contains(entry.getValue().getMailbox())) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Envelope dispatch(long time) {
        time *= 10000L;
        TreeMap<Long, Envelope> treeMap = this.envelopes;
        synchronized (treeMap) {
            HashSet<Mailbox> hashSet = this.blocked;
            synchronized (hashSet) {
                Map.Entry<Long, Envelope> envelope = this.firstEnvelope();
                if (envelope != null && envelope.getKey() < time) {
                    this.envelopes.remove(envelope.getKey());
                    envelope.getValue().getMailbox().removeEnvelope(envelope.getKey());
                    this.blocked.add(envelope.getValue().getMailbox());
                    return envelope.getValue();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waitDelay(long time) {
        time *= 10000L;
        TreeMap<Long, Envelope> treeMap = this.envelopes;
        synchronized (treeMap) {
            HashSet<Mailbox> hashSet = this.blocked;
            synchronized (hashSet) {
                Map.Entry<Long, Envelope> envelope = this.firstEnvelope();
                if (envelope != null) {
                    if (envelope.getKey() <= time) {
                        return 0L;
                    }
                    return (time - envelope.getKey()) / 10000L;
                }
            }
        }
        return Long.MAX_VALUE;
    }

    @Override
    protected void putToQueueImpl(Envelope message, long atTime) {
        this.sendEnvelope(message, atTime);
    }
}

