/*
 * Decompiled with CFR 0.152.
 */
package com.droidkit.actors.mailbox;

import com.droidkit.actors.mailbox.Envelope;
import com.droidkit.actors.mailbox.MailboxesQueue;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Mailbox {
    private final ConcurrentHashMap<Long, Envelope> envelopes = new ConcurrentHashMap();
    private MailboxesQueue queue;

    public Mailbox(MailboxesQueue queue) {
        this.queue = queue;
    }

    public void schedule(Envelope envelope, long time) {
        if (envelope.getMailbox() != this) {
            throw new RuntimeException("envelope.mailbox != this mailbox");
        }
        long id = this.queue.sendEnvelope(envelope, time);
        this.envelopes.put(id, envelope);
    }

    public void scheduleOnce(Envelope envelope, long time) {
        if (envelope.getMailbox() != this) {
            throw new RuntimeException("envelope.mailbox != this mailbox");
        }
        Iterator<Map.Entry<Long, Envelope>> iterator = this.envelopes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Envelope> entry = iterator.next();
            if (!this.isEqualEnvelope(entry.getValue(), envelope)) continue;
            this.queue.removeEnvelope(entry.getKey());
            iterator.remove();
        }
        this.schedule(envelope, time);
    }

    void removeEnvelope(long key) {
        this.envelopes.remove(key);
    }

    protected boolean isEqualEnvelope(Envelope a, Envelope b) {
        return a.getMessage().getClass() == b.getMessage().getClass();
    }

    public synchronized Envelope[] allEnvelopes() {
        return this.envelopes.values().toArray(new Envelope[0]);
    }

    public synchronized int getMailboxSize() {
        return this.envelopes.size();
    }
}

