/*
 * Decompiled with CFR 0.152.
 */
package com.droidkit.actors.mailbox;

import com.droidkit.actors.ActorRef;
import com.droidkit.actors.ActorScope;
import com.droidkit.actors.ActorSystem;
import com.droidkit.actors.CurrentActor;
import com.droidkit.actors.Props;
import com.droidkit.actors.dispatch.AbstractDispatcher;
import com.droidkit.actors.mailbox.Envelope;
import com.droidkit.actors.mailbox.Mailbox;
import com.droidkit.actors.mailbox.MailboxesQueue;
import com.droidkit.actors.messages.DeadLetter;
import com.droidkit.actors.messages.PoisonPill;
import com.droidkit.actors.messages.StartActor;
import java.util.HashMap;
import java.util.UUID;

public abstract class AbsActorDispatcher {
    private final HashMap<Mailbox, ActorScope> mailboxes = new HashMap();
    private final HashMap<String, ActorScope> scopes = new HashMap();
    private final HashMap<String, Props> actorProps = new HashMap();
    private final ActorSystem actorSystem;
    private AbstractDispatcher<Envelope, MailboxesQueue> dispatcher;

    public AbsActorDispatcher(ActorSystem actorSystem) {
        this.actorSystem = actorSystem;
    }

    protected void initDispatcher(AbstractDispatcher<Envelope, MailboxesQueue> dispatcher) {
        if (this.dispatcher != null) {
            throw new RuntimeException("Double dispatcher init");
        }
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ActorScope createScope(String path, Props props) {
        Mailbox mailbox = new Mailbox(this.dispatcher.getQueue());
        UUID uuid = UUID.randomUUID();
        ActorRef ref = new ActorRef(this.actorSystem, this, uuid, path);
        ActorScope scope = new ActorScope(this.actorSystem, mailbox, ref, this, UUID.randomUUID(), path, props);
        HashMap<Mailbox, ActorScope> hashMap = this.mailboxes;
        synchronized (hashMap) {
            this.mailboxes.put(mailbox, scope);
            this.scopes.put(scope.getPath(), scope);
            this.actorProps.put(path, props);
        }
        scope.getActorRef().send(StartActor.INSTANCE);
        return scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnectScope(ActorScope scope) {
        Envelope[] envelopeArray = this.mailboxes;
        synchronized (this.mailboxes) {
            this.mailboxes.remove(scope.getMailbox());
            this.scopes.remove(scope.getPath());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (Envelope envelope : scope.getMailbox().allEnvelopes()) {
                if (envelope.getSender() == null) continue;
                envelope.getSender().send(new DeadLetter(envelope.getMessage()));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendMessage(String path, Object message, long time, ActorRef sender) {
        HashMap<Mailbox, ActorScope> hashMap = this.mailboxes;
        synchronized (hashMap) {
            if (!this.scopes.containsKey(path)) {
                if (sender != null) {
                    sender.send(new DeadLetter(message));
                }
            } else {
                Mailbox mailbox = this.scopes.get(path).getMailbox();
                mailbox.schedule(new Envelope(message, mailbox, sender), time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendMessageOnce(String path, Object message, long time, ActorRef sender) {
        HashMap<Mailbox, ActorScope> hashMap = this.mailboxes;
        synchronized (hashMap) {
            if (!this.scopes.containsKey(path)) {
                if (sender != null) {
                    sender.send(new DeadLetter(message));
                }
            } else {
                Mailbox mailbox = this.scopes.get(path).getMailbox();
                mailbox.scheduleOnce(new Envelope(message, mailbox, sender), time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEnvelope(Envelope envelope) {
        ActorScope actor = null;
        HashMap<Mailbox, ActorScope> hashMap = this.mailboxes;
        synchronized (hashMap) {
            actor = this.mailboxes.get(envelope.getMailbox());
        }
        if (actor == null) {
            return;
        }
        try {
            if (envelope.getMessage() == StartActor.INSTANCE) {
                try {
                    actor.createActor();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (envelope.getMessage() == PoisonPill.INSTANCE) {
                try {
                    actor.shutdownActor();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                CurrentActor.setCurrentActor(actor.getActor());
                actor.setSender(envelope.getSender());
                actor.getActor().onReceiveGlobal(envelope.getMessage());
            }
        }
        finally {
            this.dispatcher.getQueue().unlockMailbox(envelope.getMailbox());
            CurrentActor.setCurrentActor(null);
        }
    }
}

