/*
 * Decompiled with CFR 0.152.
 */
package com.droidkit.actors.dispatch;

import com.droidkit.actors.ActorTime;
import com.droidkit.actors.dispatch.AbstractDispatchQueue;
import com.droidkit.actors.dispatch.AbstractDispatcher;
import com.droidkit.actors.dispatch.Dispatch;

public class ThreadPoolDispatcher<T, Q extends AbstractDispatchQueue<T>>
extends AbstractDispatcher<T, Q> {
    private final Thread[] threads;
    private boolean isClosed = false;

    public ThreadPoolDispatcher(int count, Q queue, Dispatch<T> dispatch) {
        this(count, 5, queue, dispatch);
    }

    public ThreadPoolDispatcher(int count, Q queue) {
        this(count, 5, queue, null);
    }

    public ThreadPoolDispatcher(int count, int priority, Q queue) {
        this(count, priority, queue, null);
    }

    public ThreadPoolDispatcher(int count, int priority, Q queue, Dispatch<T> dispatch) {
        super(queue, dispatch);
        this.threads = new Thread[count];
        for (int i = 0; i < count; ++i) {
            this.threads[i] = new DispatcherThread();
            this.threads[i].setPriority(priority);
            this.threads[i].start();
        }
    }

    public void close() {
        this.isClosed = true;
        this.notifyDispatcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void notifyDispatcher() {
        if (this.threads == null) return;
        Thread[] threadArray = this.threads;
        synchronized (this.threads) {
            this.threads.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private class DispatcherThread
    extends Thread {
        private DispatcherThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!ThreadPoolDispatcher.this.isClosed) {
                Object action = ((AbstractDispatchQueue)ThreadPoolDispatcher.this.getQueue()).dispatch(ActorTime.currentTime());
                if (action == null) {
                    Thread[] threadArray = ThreadPoolDispatcher.this.threads;
                    synchronized (threadArray) {
                        try {
                            long delay = ((AbstractDispatchQueue)ThreadPoolDispatcher.this.getQueue()).waitDelay(ActorTime.currentTime());
                            if (delay > 0L) {
                                ThreadPoolDispatcher.this.threads.wait(delay);
                            }
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            return;
                        }
                    }
                }
                try {
                    ThreadPoolDispatcher.this.dispatchMessage(action);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

