/*
 * Decompiled with CFR 0.152.
 */
package com.droidkit.actors.dispatch;

import com.droidkit.actors.dispatch.AbstractDispatchQueue;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class SimpleDispatchQueue<T>
extends AbstractDispatchQueue<T> {
    protected final TreeMap<Long, Message> messages = new TreeMap();
    protected final ArrayList<Message> freeMessages = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromQueue(T t) {
        TreeMap<Long, Message> treeMap = this.messages;
        synchronized (treeMap) {
            for (Map.Entry<Long, Message> messageEntry : this.messages.entrySet()) {
                if (!messageEntry.getValue().equals(t)) continue;
                Message message = this.messages.remove(messageEntry.getKey());
                this.recycle(message);
                this.notifyQueueChanged();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T dispatch(long time) {
        TreeMap<Long, Message> treeMap = this.messages;
        synchronized (treeMap) {
            long firstKey;
            if (this.messages.size() > 0 && (firstKey = this.messages.firstKey().longValue()) < time) {
                Message message = this.messages.remove(firstKey);
                Object res = message.action;
                this.recycle(message);
                return res;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waitDelay(long time) {
        TreeMap<Long, Message> treeMap = this.messages;
        synchronized (treeMap) {
            if (this.messages.size() > 0) {
                long firstKey = this.messages.firstKey();
                if (firstKey < time) {
                    return 0L;
                }
                return time - firstKey;
            }
        }
        return Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putToQueueImpl(T action, long atTime) {
        Message message = this.obtainMessage();
        message.setMessage(action, atTime);
        TreeMap<Long, Message> treeMap = this.messages;
        synchronized (treeMap) {
            while (this.messages.containsKey(atTime)) {
                ++atTime;
            }
            this.messages.put(atTime, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message obtainMessage() {
        ArrayList<Message> arrayList = this.freeMessages;
        synchronized (arrayList) {
            if (this.freeMessages.size() > 0) {
                return this.freeMessages.remove(0);
            }
        }
        return new Message();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycle(Message message) {
        ArrayList<Message> arrayList = this.freeMessages;
        synchronized (arrayList) {
            this.freeMessages.add(message);
        }
    }

    protected class Message {
        public long destTime;
        public T action;

        protected Message() {
        }

        public void setMessage(T action, long destTime) {
            this.action = action;
            this.destTime = destTime;
        }
    }
}

