/*
 * Decompiled with CFR 0.152.
 */
package com.droidkit.actors.dispatch;

import com.droidkit.actors.dispatch.AbstractDispatchQueue;
import com.droidkit.actors.dispatch.Dispatch;
import com.droidkit.actors.dispatch.QueueListener;

public abstract class AbstractDispatcher<T, Q extends AbstractDispatchQueue<T>> {
    private final Q queue;
    final Dispatch<T> dispatch;

    protected AbstractDispatcher(Q queue, Dispatch<T> dispatch) {
        this.queue = queue;
        this.dispatch = dispatch;
        ((AbstractDispatchQueue)this.queue).setListener(new QueueListener(){

            @Override
            public void onQueueChanged() {
                AbstractDispatcher.this.notifyDispatcher();
            }
        });
    }

    public Q getQueue() {
        return this.queue;
    }

    protected void dispatchMessage(T message) {
        if (this.dispatch != null) {
            this.dispatch.dispatchMessage(message);
        }
    }

    protected void notifyDispatcher() {
    }
}

