/*
 * Decompiled with CFR 0.152.
 */
package com.droidkit.actors;

import com.droidkit.actors.Actor;
import com.droidkit.actors.messages.NamedMessage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ReflectedActor
extends Actor {
    private ArrayList<Event> events = new ArrayList();
    private ArrayList<NamedEvent> namedEvents = new ArrayList();

    @Override
    public final void preStart() {
        Method[] methods;
        for (Method m : methods = this.getClass().getDeclaredMethods()) {
            String methodName;
            String name;
            if (m.getName().startsWith("onReceive") && m.getParameterTypes().length == 1) {
                if (m.getName().equals("onReceive") && m.getParameterTypes()[0] == Object.class) continue;
                this.events.add(new Event(m.getParameterTypes()[0], m));
                continue;
            }
            if (!m.getName().startsWith("on") || !m.getName().endsWith("Receive") || (name = (methodName = m.getName()).substring("on".length(), methodName.length() - "Receive".length())).length() <= 0) continue;
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
            this.namedEvents.add(new NamedEvent(name, m.getParameterTypes()[0], m));
        }
        this.preStartImpl();
    }

    public void preStartImpl() {
    }

    @Override
    public void onReceive(Object message) {
        if (message instanceof NamedMessage) {
            NamedMessage named = (NamedMessage)message;
            for (NamedEvent event : this.namedEvents) {
                if (!event.name.equals(named.getName()) || !event.check(named.getMessage())) continue;
                try {
                    event.method.invoke((Object)this, named.getMessage());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        for (Event event : this.events) {
            if (!event.check(message)) continue;
            try {
                event.method.invoke((Object)this, message);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return;
        }
    }

    class Event {
        private Class arg;
        private Method method;

        Event(Class arg, Method method) {
            this.arg = arg;
            this.method = method;
        }

        public boolean check(Object obj) {
            return this.arg.isAssignableFrom(obj.getClass());
        }
    }

    class NamedEvent {
        private String name;
        private Class arg;
        private Method method;

        NamedEvent(String name, Class arg, Method method) {
            this.name = name;
            this.arg = arg;
            this.method = method;
        }

        public String getName() {
            return this.name;
        }

        public Class getArg() {
            return this.arg;
        }

        public Method getMethod() {
            return this.method;
        }

        public boolean check(Object obj) {
            return this.arg.isAssignableFrom(obj.getClass());
        }
    }
}

