/*
 * Decompiled with CFR 0.152.
 */
package com.droidkit.actors;

import com.droidkit.actors.Actor;
import com.droidkit.actors.ActorCreator;

public final class Props<T extends Actor> {
    private static final int TYPE_DEFAULT = 1;
    private static final int TYPE_CREATOR = 2;
    private final Class<T> aClass;
    private final Object[] args;
    private final int type;
    private final ActorCreator<T> creator;
    private final String dispatcher;

    private Props(Class<T> aClass, Object[] args, int type, String dispatcher, ActorCreator<T> creator) {
        this.aClass = aClass;
        this.args = args;
        this.type = type;
        this.creator = creator;
        this.dispatcher = dispatcher;
    }

    public T create() throws Exception {
        if (this.type == 1) {
            if (this.args == null || this.args.length == 0) {
                return (T)((Actor)this.aClass.newInstance());
            }
        } else if (this.type == 2) {
            return this.creator.create();
        }
        throw new RuntimeException("Unsupported create method");
    }

    public String getDispatcher() {
        return this.dispatcher;
    }

    public Props<T> changeDispatcher(String dispatcher) {
        return new Props<T>(this.aClass, this.args, this.type, dispatcher, this.creator);
    }

    public static <T extends Actor> Props<T> create(Class<T> tClass) {
        return new Props<T>(tClass, null, 1, null, null);
    }

    public static <T extends Actor> Props<T> create(Class<T> clazz, ActorCreator<T> creator) {
        return new Props<T>(clazz, null, 2, null, creator);
    }
}

