/*
 * Decompiled with CFR 0.152.
 */
package com.droidkit.actors;

import com.droidkit.actors.Actor;
import com.droidkit.actors.ActorRef;
import com.droidkit.actors.ActorScope;
import com.droidkit.actors.ActorSelection;
import com.droidkit.actors.Props;
import com.droidkit.actors.mailbox.AbsActorDispatcher;
import com.droidkit.actors.mailbox.ActorDispatcher;
import java.util.HashMap;

public class ActorSystem {
    private static final ActorSystem mainSystem = new ActorSystem();
    private static final String DEFAULT_DISPATCHER = "default";
    private final HashMap<String, AbsActorDispatcher> dispatchers = new HashMap();
    private final HashMap<String, ActorScope> actors = new HashMap();

    public static ActorSystem system() {
        return mainSystem;
    }

    public ActorSystem() {
        this.addDispatcher(DEFAULT_DISPATCHER);
    }

    public void addDispatcher(String dispatcherId) {
        this.addDispatcher(dispatcherId, new ActorDispatcher(this, Runtime.getRuntime().availableProcessors()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDispatcher(String dispatcherId, AbsActorDispatcher dispatcher) {
        HashMap<String, AbsActorDispatcher> hashMap = this.dispatchers;
        synchronized (hashMap) {
            if (this.dispatchers.containsKey(dispatcherId)) {
                return;
            }
            this.dispatchers.put(dispatcherId, dispatcher);
        }
    }

    public <T extends Actor> ActorRef actorOf(ActorSelection selection) {
        return this.actorOf(selection.getProps(), selection.getPath());
    }

    public <T extends Actor> ActorRef actorOf(Class<T> actor, String path) {
        return this.actorOf(Props.create(actor), path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActorRef actorOf(Props props, String path) {
        HashMap<String, ActorScope> hashMap = this.actors;
        synchronized (hashMap) {
            AbsActorDispatcher mailboxesDispatcher;
            ActorScope scope = this.actors.get(path);
            if (scope != null) {
                return scope.getActorRef();
            }
            String dispatcherId = props.getDispatcher() == null ? DEFAULT_DISPATCHER : props.getDispatcher();
            HashMap<String, AbsActorDispatcher> hashMap2 = this.dispatchers;
            synchronized (hashMap2) {
                if (!this.dispatchers.containsKey(dispatcherId)) {
                    throw new RuntimeException("Unknown dispatcherId '" + dispatcherId + "'");
                }
                mailboxesDispatcher = this.dispatchers.get(dispatcherId);
            }
            scope = mailboxesDispatcher.createScope(path, props);
            this.actors.put(path, scope);
            return scope.getActorRef();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeActor(ActorScope scope) {
        HashMap<String, ActorScope> hashMap = this.actors;
        synchronized (hashMap) {
            if (this.actors.get(scope.getPath()) == scope) {
                this.actors.remove(scope.getPath());
            }
        }
    }
}

