/*
 * Decompiled with CFR 0.152.
 */
package com.droidkit.actors;

import com.droidkit.actors.Actor;
import com.droidkit.actors.ActorContext;
import com.droidkit.actors.ActorRef;
import com.droidkit.actors.ActorSystem;
import com.droidkit.actors.CurrentActor;
import com.droidkit.actors.Props;
import com.droidkit.actors.mailbox.AbsActorDispatcher;
import com.droidkit.actors.mailbox.Mailbox;
import java.util.UUID;

public class ActorScope {
    public static final int STATE_STARTING = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_SHUTDOWN = 2;
    private final UUID uuid;
    private final String path;
    private final Props props;
    private final ActorRef actorRef;
    private final Mailbox mailbox;
    private final AbsActorDispatcher dispatcher;
    private final ActorSystem actorSystem;
    private int state;
    private Actor actor;
    private ActorRef sender;

    public ActorScope(ActorSystem actorSystem, Mailbox mailbox, ActorRef actorRef, AbsActorDispatcher dispatcher, UUID uuid, String path, Props props) {
        this.actorSystem = actorSystem;
        this.mailbox = mailbox;
        this.actorRef = actorRef;
        this.dispatcher = dispatcher;
        this.uuid = uuid;
        this.path = path;
        this.props = props;
        this.state = 0;
    }

    public AbsActorDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public int getState() {
        return this.state;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getPath() {
        return this.path;
    }

    public Props getProps() {
        return this.props;
    }

    public ActorRef getActorRef() {
        return this.actorRef;
    }

    public Mailbox getMailbox() {
        return this.mailbox;
    }

    public Actor getActor() {
        return this.actor;
    }

    public ActorSystem getActorSystem() {
        return this.actorSystem;
    }

    public ActorRef getSender() {
        return this.sender;
    }

    public void setSender(ActorRef sender) {
        this.sender = sender;
    }

    public void createActor() throws Exception {
        if (this.state != 0) {
            if (this.state == 1) {
                throw new RuntimeException("Actor already created");
            }
            if (this.state == 2) {
                throw new RuntimeException("Actor shutdown");
            }
            throw new RuntimeException("Unknown ActorScope state");
        }
        this.actor = this.props.create();
        CurrentActor.setCurrentActor(this.actor);
        this.actor.initActor(this.getUuid(), this.getPath(), new ActorContext(this), this.getMailbox());
        this.actor.preStart();
    }

    public void shutdownActor() throws Exception {
        if (this.state != 0 && this.state != 1 && this.state != 2) {
            throw new RuntimeException("Unknown ActorScope state");
        }
        this.actorSystem.removeActor(this);
        this.dispatcher.disconnectScope(this);
        this.actor.postStop();
        this.actor = null;
    }
}

