/*
 * Decompiled with CFR 0.152.
 */
package com.droidkit.actors;

import com.droidkit.actors.ActorSystem;
import com.droidkit.actors.ActorTime;
import com.droidkit.actors.mailbox.AbsActorDispatcher;
import java.util.UUID;

public class ActorRef {
    private ActorSystem system;
    private AbsActorDispatcher dispatcher;
    private UUID uuid;
    private String path;

    public UUID getUuid() {
        return this.uuid;
    }

    public String getPath() {
        return this.path;
    }

    public ActorRef(ActorSystem system, AbsActorDispatcher dispatcher, UUID uuid, String path) {
        this.system = system;
        this.dispatcher = dispatcher;
        this.uuid = uuid;
        this.path = path;
    }

    public void send(Object message) {
        this.send(message, null);
    }

    public void send(Object message, ActorRef sender) {
        this.send(message, 0L, sender);
    }

    public void send(Object message, long delay) {
        this.send(message, delay, null);
    }

    public void send(Object message, long delay, ActorRef sender) {
        this.dispatcher.sendMessage(this.path, message, ActorTime.currentTime() + delay, sender);
    }

    public void sendOnce(Object message) {
        this.send(message, null);
    }

    public void sendOnce(Object message, ActorRef sender) {
        this.sendOnce(message, 0L, sender);
    }

    public void sendOnce(Object message, long delay) {
        this.sendOnce(message, delay, null);
    }

    public void sendOnce(Object message, long delay, ActorRef sender) {
        this.dispatcher.sendMessageOnce(this.path, message, ActorTime.currentTime() + delay, sender);
    }
}

