/*
 * Decompiled with CFR 0.152.
 */
package com.droidkit.actors;

import com.droidkit.actors.ActorContext;
import com.droidkit.actors.ActorRef;
import com.droidkit.actors.ActorSelection;
import com.droidkit.actors.ActorSystem;
import com.droidkit.actors.mailbox.Mailbox;
import com.droidkit.actors.messages.DeadLetter;
import com.droidkit.actors.messages.NamedMessage;
import com.droidkit.actors.tasks.ActorAskImpl;
import com.droidkit.actors.tasks.AskCallback;
import com.droidkit.actors.tasks.AskFuture;
import com.droidkit.actors.tasks.messages.TaskError;
import com.droidkit.actors.tasks.messages.TaskResult;
import com.droidkit.actors.tasks.messages.TaskTimeout;
import java.lang.reflect.Array;
import java.util.UUID;

public class Actor {
    private UUID uuid;
    private String path;
    private ActorContext context;
    private Mailbox mailbox;
    private ActorAskImpl askPattern;

    public final void initActor(UUID uuid, String path, ActorContext context, Mailbox mailbox) {
        this.uuid = uuid;
        this.path = path;
        this.context = context;
        this.mailbox = mailbox;
        this.askPattern = new ActorAskImpl(this.self());
    }

    public final ActorSystem system() {
        return this.context.getSystem();
    }

    public final ActorRef self() {
        return this.context.getSelf();
    }

    protected final ActorContext context() {
        return this.context;
    }

    public final ActorRef sender() {
        return this.context.sender();
    }

    protected final UUID getUuid() {
        return this.uuid;
    }

    protected final String getPath() {
        return this.path;
    }

    public final Mailbox getMailbox() {
        return this.mailbox;
    }

    public void preStart() {
    }

    public final void onReceiveGlobal(Object message) {
        if (message instanceof DeadLetter ? this.askPattern.onDeadLetter((DeadLetter)message) : (message instanceof TaskResult ? this.askPattern.onTaskResult((TaskResult)message) : (message instanceof TaskTimeout ? this.askPattern.onTaskTimeout((TaskTimeout)message) : message instanceof TaskError && this.askPattern.onTaskError((TaskError)message)))) {
            return;
        }
        this.onReceive(message);
    }

    public void onReceive(Object message) {
    }

    public void postStop() {
    }

    public void reply(Object message) {
        if (this.context.sender() != null) {
            this.context.sender().send(message, this.self());
        }
    }

    public AskFuture combine(AskFuture ... futures) {
        return this.askPattern.combine(futures);
    }

    public AskFuture combine(AskCallback<Object[]> callback, AskFuture ... futures) {
        AskFuture future = this.combine(futures);
        future.addListener(callback);
        return future;
    }

    public <T> AskFuture combine(final String name, final Class<T> clazz, AskFuture ... futures) {
        return this.combine(new AskCallback<Object[]>(){

            @Override
            public void onResult(Object[] result) {
                Object[] res = (Object[])Array.newInstance(clazz, result.length);
                for (int i = 0; i < result.length; ++i) {
                    res[i] = result[i];
                }
                Actor.this.self().send(new NamedMessage(name, res));
            }

            @Override
            public void onError(Throwable throwable) {
                Actor.this.self().send(new NamedMessage(name, throwable));
            }
        }, futures);
    }

    public <T> AskFuture combine(final String name, AskFuture ... futures) {
        return this.combine(new AskCallback<Object[]>(){

            @Override
            public void onResult(Object[] result) {
                Actor.this.self().send(new NamedMessage(name, result));
            }

            @Override
            public void onError(Throwable throwable) {
                Actor.this.self().send(new NamedMessage(name, throwable));
            }
        }, futures);
    }

    public AskFuture ask(ActorSelection selection) {
        return this.askPattern.ask(this.system().actorOf(selection), 0L, null);
    }

    public AskFuture ask(ActorSelection selection, long timeout) {
        return this.askPattern.ask(this.system().actorOf(selection), timeout, null);
    }

    public AskFuture ask(ActorSelection selection, AskCallback callback) {
        return this.askPattern.ask(this.system().actorOf(selection), 0L, callback);
    }

    public AskFuture ask(ActorSelection selection, long timeout, AskCallback callback) {
        return this.askPattern.ask(this.system().actorOf(selection), timeout, callback);
    }

    public AskFuture ask(ActorRef ref) {
        return this.askPattern.ask(ref, 0L, null);
    }

    public AskFuture ask(ActorRef ref, long timeout) {
        return this.askPattern.ask(ref, timeout, null);
    }

    public AskFuture ask(ActorRef ref, AskCallback callback) {
        return this.askPattern.ask(ref, 0L, callback);
    }

    public AskFuture ask(ActorRef ref, long timeout, AskCallback callback) {
        return this.askPattern.ask(ref, timeout, callback);
    }
}

