/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URISyntaxException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlbeam.AutoList;
import org.xmlbeam.AutoMap;
import org.xmlbeam.AutoValue;
import org.xmlbeam.DefaultFileIO;
import org.xmlbeam.MixinHolder;
import org.xmlbeam.ProjectionFactory;
import org.xmlbeam.ProjectionFactoryConfig;
import org.xmlbeam.ProjectionInvocationHandler;
import org.xmlbeam.annotation.XBAuto;
import org.xmlbeam.annotation.XBDelete;
import org.xmlbeam.annotation.XBDocURL;
import org.xmlbeam.annotation.XBRead;
import org.xmlbeam.annotation.XBUpdate;
import org.xmlbeam.annotation.XBValue;
import org.xmlbeam.annotation.XBWrite;
import org.xmlbeam.config.DefaultXMLFactoriesConfig;
import org.xmlbeam.config.XMLFactoriesConfig;
import org.xmlbeam.dom.DOMAccess;
import org.xmlbeam.evaluation.CanEvaluateOrProject;
import org.xmlbeam.evaluation.DefaultXPathEvaluator;
import org.xmlbeam.evaluation.DocumentResolver;
import org.xmlbeam.evaluation.InvocationContext;
import org.xmlbeam.evaluation.XPathEvaluator;
import org.xmlbeam.externalizer.Externalizer;
import org.xmlbeam.externalizer.ExternalizerAdapter;
import org.xmlbeam.intern.DOMChangeListener;
import org.xmlbeam.io.FileIO;
import org.xmlbeam.io.ProjectionIO;
import org.xmlbeam.io.StreamInput;
import org.xmlbeam.io.StreamOutput;
import org.xmlbeam.io.UrlIO;
import org.xmlbeam.types.DefaultTypeConverter;
import org.xmlbeam.types.StringRenderer;
import org.xmlbeam.types.TypeConverter;
import org.xmlbeam.types.XBAutoMap;
import org.xmlbeam.util.IOHelper;
import org.xmlbeam.util.intern.DOMHelper;
import org.xmlbeam.util.intern.DocScope;
import org.xmlbeam.util.intern.ReflectionHelper;
import org.xmlbeam.util.intern.Scope;

public class XBProjector
implements Serializable,
ProjectionFactory {
    private static final Externalizer NOOP_EXTERNALIZER = new ExternalizerAdapter();
    private final ConfigBuilder configBuilder = new ConfigBuilder();
    private Externalizer externalizer = NOOP_EXTERNALIZER;
    private final Set<Flags> flags;
    private final XMLFactoriesConfig xMLFactoriesConfig;
    private final Map<Class<?>, Map<Class<?>, Object>> mixins = new HashMap();
    private TypeConverter typeConverter = new DefaultTypeConverter(Locale.getDefault(), TimeZone.getTimeZone("GMT"));
    private StringRenderer stringRenderer = (StringRenderer)((Object)this.typeConverter);
    private final List<WeakReference<DOMChangeListener>> domChangeListeners = new LinkedList<WeakReference<DOMChangeListener>>();

    @Override
    @Scope(value=DocScope.IO)
    public <T> T projectEmptyDocument(Class<T> projectionInterface) {
        Document document = this.xMLFactoriesConfig.createDocumentBuilder().newDocument();
        return this.projectDOMNode(document, projectionInterface);
    }

    @Override
    @Scope(value=DocScope.IO)
    public <T> T projectEmptyElement(String name, Class<T> projectionInterface) {
        Document document = this.xMLFactoriesConfig.createDocumentBuilder().newDocument();
        Element element = document.createElement(name);
        return this.projectDOMNode(element, projectionInterface);
    }

    @Override
    @Scope(value=DocScope.IO)
    public <T> T projectDOMNode(Node documentOrElement, Class<T> projectionInterface) {
        this.ensureIsValidProjectionInterface(projectionInterface);
        if (documentOrElement == null) {
            throw new IllegalArgumentException("Parameter node must not be null");
        }
        Map<Class<?>, Object> mixinsForProjection = this.mixins.containsKey(projectionInterface) ? Collections.unmodifiableMap(this.mixins.get(projectionInterface)) : Collections.emptyMap();
        final ProjectionInvocationHandler projectionInvocationHandler = new ProjectionInvocationHandler(this, documentOrElement, projectionInterface, mixinsForProjection, this.flags.contains((Object)Flags.TO_STRING_RENDERS_XML), this.flags.contains((Object)Flags.ABSENT_IS_EMPTY));
        HashSet<Class<Object>> interfaces = new HashSet<Class<Object>>();
        interfaces.add(projectionInterface);
        interfaces.add(DOMAccess.class);
        interfaces.add(Serializable.class);
        if (this.flags.contains((Object)Flags.SYNCHRONIZE_ON_DOCUMENTS)) {
            final Document document = DOMHelper.getOwnerDocumentFor(documentOrElement);
            InvocationHandler synchronizedInvocationHandler = new InvocationHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Document document2 = document;
                    synchronized (document2) {
                        return projectionInvocationHandler.invoke(proxy, method, args);
                    }
                }
            };
            return (T)Proxy.newProxyInstance(projectionInterface.getClassLoader(), interfaces.toArray(new Class[interfaces.size()]), synchronizedInvocationHandler);
        }
        return (T)Proxy.newProxyInstance(projectionInterface.getClassLoader(), interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)projectionInvocationHandler);
    }

    @Override
    @Scope(value=DocScope.IO)
    public <T> T projectXMLString(String xmlContent, Class<T> projectionInterface) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlContent.getBytes("utf-8"));
            return new StreamInput(this, inputStream).read(projectionInterface);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Scope(value=DocScope.IO)
    public CanEvaluateOrProject onXMLString(final String xmlContent) {
        try {
            final ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlContent.getBytes("utf-8"));
            return new CanEvaluateOrProject(){

                @Override
                public XPathEvaluator evalXPath(String xpath) {
                    return new DefaultXPathEvaluator(XBProjector.this, new DocumentResolver(){

                        @Override
                        public Document resolve(Class<?> ... resourceAwareClass) {
                            return IOHelper.loadDocument(XBProjector.this, inputStream);
                        }
                    }, xpath);
                }

                @Override
                public <T> T createProjection(Class<T> projectionInterface) {
                    return XBProjector.this.projectXMLString(xmlContent, projectionInterface);
                }

                @Override
                public <T> XBAutoMap<T> createMapOf(Class<T> valueType) {
                    Document document = IOHelper.loadDocument(XBProjector.this, inputStream);
                    return XBProjector.this.createAutoMapForDocument(valueType, document);
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public XBProjector(Flags ... optionalFlags) {
        this(new DefaultXMLFactoriesConfig(), optionalFlags);
    }

    private static <T extends Enum<T>> Set<T> unfold(T[] array) {
        if (array == null || array.length == 0) {
            return Collections.emptySet();
        }
        EnumSet<T> enumSet = EnumSet.of(array[0]);
        for (int i = 1; i < array.length; ++i) {
            enumSet.add(array[i]);
        }
        return enumSet;
    }

    public XBProjector(XMLFactoriesConfig xMLFactoriesConfig, Flags ... optionalFlags) {
        this.xMLFactoriesConfig = xMLFactoriesConfig;
        this.flags = XBProjector.unfold((Enum[])optionalFlags);
    }

    public ConfigBuilder config() {
        return this.configBuilder;
    }

    public MixinHolder mixins() {
        return new MixinBuilder();
    }

    private DOMAccess checkProjectionInstance(Object projection) {
        InvocationHandler invocationHandler;
        if (Proxy.isProxyClass(projection.getClass()) && (invocationHandler = Proxy.getInvocationHandler(projection)) instanceof ProjectionInvocationHandler && projection instanceof DOMAccess) {
            return (DOMAccess)projection;
        }
        throw new IllegalArgumentException("Given object " + projection + " is not a projection.");
    }

    private void ensureIsValidProjectionInterface(Class<?> projectionInterface) {
        if (projectionInterface == null) {
            throw new IllegalArgumentException("Parameter projectionInterface must not be null, but is.", new NullPointerException());
        }
        if (!projectionInterface.isInterface()) {
            throw new IllegalArgumentException("Parameter " + projectionInterface + " is not an interface");
        }
        if (projectionInterface.isAnnotation()) {
            throw new IllegalArgumentException("Parameter " + projectionInterface + " is an annotation interface. Remove the @ and try again.");
        }
        for (Method method : projectionInterface.getMethods()) {
            boolean isThrowsException;
            boolean isRead = method.getAnnotation(XBRead.class) != null;
            boolean isWrite = method.getAnnotation(XBWrite.class) != null;
            boolean isDelete = method.getAnnotation(XBDelete.class) != null;
            boolean isUpdate = method.getAnnotation(XBUpdate.class) != null;
            boolean isBind = method.getAnnotation(XBAuto.class) != null;
            boolean isExternal = method.getAnnotation(XBDocURL.class) != null;
            boolean bl = isThrowsException = method.getExceptionTypes().length > 0;
            if (XBProjector.countTrue(isRead, isWrite, isDelete, isUpdate, isBind) > 1) {
                throw new IllegalArgumentException("Method " + method + " has to many annotations. Decide for one of @" + XBRead.class.getSimpleName() + ", @" + XBWrite.class.getSimpleName() + ", @" + XBUpdate.class.getSimpleName() + ", or @" + XBDelete.class.getSimpleName() + ", or @" + XBAuto.class.getSimpleName());
            }
            if (isExternal && (isWrite || isUpdate || isDelete)) {
                throw new IllegalArgumentException("Method " + method + " was declared as writing projection but has a @" + XBDocURL.class.getSimpleName() + " annotation. Defining external projections is only possible when reading because there is no DOM attached.");
            }
            if (isRead) {
                if (!ReflectionHelper.hasReturnType(method)) {
                    throw new IllegalArgumentException("Method " + method + " has @" + XBRead.class.getSimpleName() + " annotation, but has no return type.");
                }
                if (ReflectionHelper.isRawType(method.getGenericReturnType())) {
                    throw new IllegalArgumentException("Method " + method + " has @" + XBRead.class.getSimpleName() + " annotation, but has a raw return type.");
                }
                if (method.getExceptionTypes().length > 1) {
                    throw new IllegalArgumentException("Method " + method + " has @" + XBRead.class.getSimpleName() + " annotation, but declares to throw multiple exceptions. Which one should I throw?");
                }
                if (ReflectionHelper.isOptional(method.getReturnType()) && isThrowsException) {
                    throw new IllegalArgumentException("Method " + method + " has an Optional<> return type, but declares to throw an exception. Exception will never be thrown because return value must not be null.");
                }
            }
            if (isWrite && isThrowsException) {
                throw new IllegalArgumentException("Method " + method + " declares to throw exception " + method.getExceptionTypes()[0].getSimpleName() + " but is not a reading projection method. When should this exception be thrown?");
            }
            if (isWrite && !ReflectionHelper.hasParameters(method)) {
                throw new IllegalArgumentException("Method " + method + " has @" + XBWrite.class.getSimpleName() + " annotaion, but has no paramerter");
            }
            if (isUpdate && !ReflectionHelper.hasParameters(method)) {
                throw new IllegalArgumentException("Method " + method + " has @" + XBUpdate.class.getSimpleName() + " annotaion, but has no paramerter");
            }
            for (Class<?> clazz : method.getParameterTypes()) {
                if (!ReflectionHelper.isOptional(clazz)) continue;
                throw new IllegalArgumentException("Method " + method + " has java.util.Optional as a parameter type. You simply never should not do this.");
            }
            int count = 0;
            Annotation[][] annotationArray = method.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] paramAnnotations;
                for (Annotation a : paramAnnotations = annotationArray[i]) {
                    if (!XBValue.class.equals(a.annotationType())) continue;
                    if (!isWrite && !isUpdate) {
                        throw new IllegalArgumentException("Method " + method + " is not a writing projection method, but has an @" + XBValue.class.getSimpleName() + " annotaion.");
                    }
                    if (count > 0) {
                        throw new IllegalArgumentException("Method " + method + " has multiple @" + XBValue.class.getSimpleName() + " annotaions.");
                    }
                    ++count;
                }
            }
        }
    }

    private static int countTrue(boolean ... b) {
        if (b == null) {
            return 0;
        }
        int count = 0;
        for (boolean bb : b) {
            if (!bb) continue;
            ++count;
        }
        return count;
    }

    @Override
    @Scope(value=DocScope.IO)
    public ProjectionIO io() {
        return new IOBuilder();
    }

    @Override
    public String asString(Object projection) {
        if (projection instanceof AutoValue) {
            return DOMHelper.toXMLString(this, ((AutoValue)projection).getNode());
        }
        if (projection instanceof AutoList) {
            return DOMHelper.toXMLString(this, ((AutoList)projection).getNode());
        }
        if (projection instanceof AutoMap) {
            return DOMHelper.toXMLString(this, ((AutoMap)projection).getNode());
        }
        if (!(projection instanceof DOMAccess)) {
            throw new IllegalArgumentException("Argument is not a projection.");
        }
        DOMAccess domAccess = (DOMAccess)projection;
        return domAccess.asString();
    }

    public Set<Flags> getFlags() {
        return Collections.unmodifiableSet(this.flags);
    }

    void addDOMChangeListener(DOMChangeListener listener) {
        this.domChangeListeners.add(new WeakReference<DOMChangeListener>(listener));
    }

    void notifyDOMChangeListeners() {
        ListIterator<WeakReference<DOMChangeListener>> i = this.domChangeListeners.listIterator();
        while (i.hasNext()) {
            DOMChangeListener listener = (DOMChangeListener)i.next().get();
            if (listener == null) {
                i.remove();
                continue;
            }
            listener.domChanged();
        }
    }

    public <T> XBAutoMap<T> autoMapEmptyDocument(Class<T> valueType) {
        Document document = this.xMLFactoriesConfig.createDocumentBuilder().newDocument();
        return this.createAutoMapForDocument(valueType, document);
    }

    private <T> XBAutoMap<T> createAutoMapForDocument(Class<T> valueType, Document document) {
        InvocationContext invocationContext = new InvocationContext(null, null, null, null, null, valueType, this);
        return new AutoMap(document, invocationContext, valueType);
    }

    public static enum Flags {
        SYNCHRONIZE_ON_DOCUMENTS,
        TO_STRING_RENDERS_XML,
        OMIT_EMPTY_NODES,
        ABSENT_IS_EMPTY;

    }

    class IOBuilder
    implements ProjectionIO {
        IOBuilder() {
        }

        @Override
        public FileIO file(File file) {
            return new DefaultFileIO(XBProjector.this, file);
        }

        @Override
        public FileIO file(String fileName) {
            return new DefaultFileIO(XBProjector.this, fileName);
        }

        @Override
        public UrlIO url(String url) {
            return new UrlIO(XBProjector.this, url);
        }

        @Override
        public StreamInput stream(InputStream is) {
            return new StreamInput(XBProjector.this, is);
        }

        @Override
        public StreamOutput stream(OutputStream os) {
            return new StreamOutput(XBProjector.this, os);
        }

        @Override
        public <T> T fromURLAnnotation(Class<T> projectionInterface, Object ... optionalParams) throws IOException {
            XBDocURL doc = projectionInterface.getAnnotation(XBDocURL.class);
            if (doc == null) {
                throw new IllegalArgumentException("Class " + projectionInterface.getCanonicalName() + " must have the " + XBDocURL.class.getName() + " annotation linking to the document source.");
            }
            UrlIO urlIO = this.url(MessageFormat.format(doc.value(), optionalParams));
            urlIO.addRequestProperties(this.filterRequestParamsFromParams(doc.value(), optionalParams));
            return urlIO.read(projectionInterface);
        }

        Map<String, String> filterRequestParamsFromParams(String url, Object ... optionalParams) {
            HashMap<String, String> requestParams = new HashMap<String, String>();
            Format[] formats = new MessageFormat(url).getFormatsByArgumentIndex();
            for (int i = 0; i < optionalParams.length; ++i) {
                if (i >= formats.length) {
                    if (!(optionalParams[i] instanceof Map)) continue;
                    requestParams.putAll((Map)optionalParams[i]);
                    continue;
                }
                if (formats[i] != null || !(optionalParams[i] instanceof Map)) continue;
                requestParams.putAll((Map)optionalParams[i]);
            }
            return requestParams;
        }

        @Override
        public String toURLAnnotationViaPOST(Object projection, Object ... optionalParams) throws IOException, URISyntaxException {
            Class<?> projectionInterface = XBProjector.this.checkProjectionInstance(projection).getProjectionInterface();
            XBDocURL doc = projectionInterface.getAnnotation(XBDocURL.class);
            if (doc == null) {
                throw new IllegalArgumentException("Class " + projectionInterface.getCanonicalName() + " must have the " + XBDocURL.class.getName() + " annotation linking to the document source.");
            }
            UrlIO urlIO = this.url(MessageFormat.format(doc.value(), optionalParams));
            urlIO.addRequestProperties(this.filterRequestParamsFromParams(doc.value(), optionalParams));
            return urlIO.write(projection);
        }
    }

    class MixinBuilder
    implements MixinHolder {
        MixinBuilder() {
        }

        @Override
        public <S, M extends S, P extends S> XBProjector addProjectionMixin(Class<P> projectionInterface, M mixinImplementation) {
            XBProjector.this.ensureIsValidProjectionInterface(projectionInterface);
            HashMap map = XBProjector.this.mixins.containsKey(projectionInterface) ? (Map)XBProjector.this.mixins.get(projectionInterface) : new HashMap();
            for (Class<?> type : ReflectionHelper.findAllCommonSuperInterfaces(projectionInterface, mixinImplementation.getClass())) {
                map.put(type, mixinImplementation);
            }
            XBProjector.this.mixins.put(projectionInterface, map);
            return XBProjector.this;
        }

        @Override
        public <S, M extends S, P extends S> M getProjectionMixin(Class<P> projectionInterface, Class<M> mixinInterface) {
            if (!XBProjector.this.mixins.containsKey(projectionInterface)) {
                return null;
            }
            return (M)((Map)XBProjector.this.mixins.get(projectionInterface)).get(mixinInterface);
        }

        @Override
        public <S, M extends S, P extends S> M removeProjectionMixin(Class<P> projectionInterface, Class<M> mixinInterface) {
            if (!XBProjector.this.mixins.containsKey(projectionInterface)) {
                return null;
            }
            return (M)((Map)XBProjector.this.mixins.get(projectionInterface)).remove(mixinInterface);
        }
    }

    public class ConfigBuilder
    implements ProjectionFactoryConfig {
        public <T extends XMLFactoriesConfig> T as(Class<T> clazz) {
            return (T)((XMLFactoriesConfig)clazz.cast(XBProjector.this.xMLFactoriesConfig));
        }

        @Override
        public TypeConverter getTypeConverter() {
            return XBProjector.this.typeConverter;
        }

        public <T extends TypeConverter> T getTypeConverterAs(Class<T> clazz) {
            return (T)((TypeConverter)clazz.cast(this.getTypeConverter()));
        }

        @Override
        public ConfigBuilder setTypeConverter(TypeConverter converter) {
            XBProjector.this.typeConverter = converter;
            return this;
        }

        @Override
        public ConfigBuilder setExternalizer(Externalizer e10r) {
            XBProjector.this.externalizer = e10r == null ? NOOP_EXTERNALIZER : e10r;
            return this;
        }

        @Override
        public Externalizer getExternalizer() {
            return XBProjector.this.externalizer;
        }

        public <T extends Externalizer> T getExternalizerAs(Class<? extends T> clazz) {
            return (T)((Externalizer)clazz.cast(this.getExternalizer()));
        }

        @Override
        public TransformerFactory createTransformerFactory() {
            return XBProjector.this.xMLFactoriesConfig.createTransformerFactory();
        }

        @Override
        public DocumentBuilderFactory createDocumentBuilderFactory() {
            return XBProjector.this.xMLFactoriesConfig.createDocumentBuilderFactory();
        }

        @Override
        public XPathFactory createXPathFactory() {
            return XBProjector.this.xMLFactoriesConfig.createXPathFactory();
        }

        @Override
        public Transformer createTransformer(Document ... document) {
            return XBProjector.this.xMLFactoriesConfig.createTransformer(document);
        }

        @Override
        public DocumentBuilder createDocumentBuilder() {
            return XBProjector.this.xMLFactoriesConfig.createDocumentBuilder();
        }

        @Override
        public XPath createXPath(Document ... document) {
            return XBProjector.this.xMLFactoriesConfig.createXPath(document);
        }

        public StringRenderer getStringRenderer() {
            return XBProjector.this.stringRenderer;
        }

        public <T extends StringRenderer> T getStringRendererAs(Class<T> clazz) {
            return (T)((StringRenderer)clazz.cast(this.getTypeConverter()));
        }

        public ConfigBuilder setStringRenderer(StringRenderer renderer) {
            XBProjector.this.stringRenderer = renderer;
            return this;
        }

        @Override
        public Map<String, String> getUserDefinedNamespaceMapping() {
            return XBProjector.this.xMLFactoriesConfig.getUserDefinedNamespaceMapping();
        }
    }
}

