/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.objectpool;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.vibur.objectpool.PoolObjectFactory;
import org.vibur.objectpool.PoolService;
import org.vibur.objectpool.listener.Listener;

public class ConcurrentLinkedPool<T>
implements PoolService<T> {
    private final PoolObjectFactory<T> poolObjectFactory;
    private final Listener<T> listener;
    private final Semaphore takeSemaphore;
    private final Queue<T> available;
    private final int initialSize;
    private final int maxSize;
    private final AtomicInteger createdTotal;
    private final AtomicBoolean terminated = new AtomicBoolean(false);

    public ConcurrentLinkedPool(PoolObjectFactory<T> poolObjectFactory, int initialSize, int maxSize, boolean fair) {
        this(poolObjectFactory, initialSize, maxSize, fair, null);
    }

    public ConcurrentLinkedPool(PoolObjectFactory<T> poolObjectFactory, int initialSize, int maxSize, boolean fair, Listener<T> listener) {
        if (initialSize < 0 || maxSize < 1 || maxSize < initialSize) {
            throw new IllegalArgumentException();
        }
        if (poolObjectFactory == null) {
            throw new NullPointerException();
        }
        this.poolObjectFactory = poolObjectFactory;
        this.listener = listener;
        this.initialSize = initialSize;
        this.maxSize = maxSize;
        this.takeSemaphore = new Semaphore(maxSize, fair);
        this.available = new ConcurrentLinkedQueue<T>();
        this.createdTotal = new AtomicInteger(0);
        for (int i = 0; i < initialSize; ++i) {
            this.available.add(this.create());
            this.createdTotal.incrementAndGet();
        }
    }

    private T create() {
        T object = this.poolObjectFactory.create();
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    @Override
    public T take() {
        try {
            this.takeSemaphore.acquire();
            return this.newObject();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public T takeUninterruptibly() {
        this.takeSemaphore.acquireUninterruptibly();
        return this.newObject();
    }

    @Override
    public T tryTake(long timeout, TimeUnit unit) {
        try {
            if (!this.takeSemaphore.tryAcquire(timeout, unit)) {
                return null;
            }
            return this.newObject();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public T tryTake() {
        if (!this.takeSemaphore.tryAcquire()) {
            return null;
        }
        return this.newObject();
    }

    protected T newObject() {
        if (this.isTerminated()) {
            this.takeSemaphore.release();
            return null;
        }
        T object = this.available.poll();
        object = this.prepareToTake(object);
        if (this.listener != null) {
            this.listener.onTake(object);
        }
        return object;
    }

    @Override
    public void restore(T object) {
        this.restore(object, true);
    }

    @Override
    public void restore(T object, boolean valid) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.isTerminated()) {
            return;
        }
        if (this.listener != null) {
            this.listener.onRestore(object);
        }
        if ((object = this.prepareToRestore(object, valid)) != null) {
            this.available.add(object);
        }
        this.takeSemaphore.release();
    }

    private T prepareToTake(T object) {
        try {
            if (object == null) {
                this.createdTotal.incrementAndGet();
                object = this.create();
            } else {
                boolean ready = false;
                try {
                    ready = this.poolObjectFactory.readyToTake(object);
                }
                finally {
                    if (!ready) {
                        this.poolObjectFactory.destroy(object);
                    }
                }
                if (!ready) {
                    object = this.create();
                }
            }
            return object;
        }
        catch (RuntimeException e) {
            this.recoverInnerState(1);
            throw e;
        }
        catch (Error e) {
            this.recoverInnerState(1);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T prepareToRestore(T object, boolean valid) {
        try {
            boolean ready = false;
            try {
                ready = valid && this.poolObjectFactory.readyToRestore(object);
            }
            finally {
                if (!ready) {
                    this.poolObjectFactory.destroy(object);
                }
            }
            if (!ready) {
                this.createdTotal.decrementAndGet();
                object = null;
            }
            return object;
        }
        catch (RuntimeException e) {
            this.recoverInnerState(1);
            throw e;
        }
        catch (Error e) {
            this.recoverInnerState(1);
            throw e;
        }
    }

    private void recoverInnerState(int permits) {
        this.createdTotal.addAndGet(-permits);
        this.takeSemaphore.release(permits);
    }

    @Override
    public Listener<T> listener() {
        return this.listener;
    }

    @Override
    public int taken() {
        return this.isTerminated() ? this.maxSize() : this.calculateTaken();
    }

    private int calculateTaken() {
        return this.maxSize() - this.remainingCapacity();
    }

    @Override
    public int remainingCreated() {
        return this.isTerminated() ? 0 : this.createdTotal() - this.calculateTaken();
    }

    @Override
    public int drainCreated() {
        return this.reduceCreated(Integer.MAX_VALUE, true);
    }

    public String toString() {
        return super.toString() + (this.isTerminated() ? "[terminated]" : "[remainingCreated = " + this.remainingCreated() + "]");
    }

    @Override
    public int createdTotal() {
        return this.createdTotal.get();
    }

    @Override
    public int remainingCapacity() {
        return this.isTerminated() ? 0 : this.takeSemaphore.availablePermits();
    }

    @Override
    public int initialSize() {
        return this.initialSize;
    }

    @Override
    public int maxSize() {
        return this.maxSize;
    }

    @Override
    public int reduceCreated(int reduction, boolean ignoreInitialSize) {
        if (reduction < 0) {
            throw new IllegalArgumentException();
        }
        for (int cnt = 0; cnt < reduction; ++cnt) {
            int newTotal = this.createdTotal.decrementAndGet();
            if (!ignoreInitialSize && newTotal < this.initialSize) {
                this.createdTotal.incrementAndGet();
                return cnt;
            }
            T object = this.available.poll();
            if (object == null) {
                this.createdTotal.incrementAndGet();
                return cnt;
            }
            this.poolObjectFactory.destroy(object);
        }
        return reduction;
    }

    @Override
    public void terminate() {
        if (this.terminated.getAndSet(true)) {
            return;
        }
        this.takeSemaphore.release(this.takeSemaphore.getQueueLength() + 4096);
        this.drainCreated();
    }

    @Override
    public boolean isTerminated() {
        return this.terminated.get();
    }

    @Override
    public boolean isFair() {
        return this.takeSemaphore.isFair();
    }
}

