/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.core.MethodParameter;
import org.springframework.kafka.listener.ListenerExecutionFailedException;
import org.springframework.kafka.listener.adapter.AbstractAdaptableMessageListener;
import org.springframework.kafka.listener.adapter.HandlerAdapter;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.kafka.support.converter.MessageConverter;
import org.springframework.kafka.support.converter.MessagingMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.handler.annotation.Payload;

public class MessagingMessageListenerAdapter<K, V>
extends AbstractAdaptableMessageListener<K, V> {
    private final Type inferredType;
    private HandlerAdapter handlerMethod;
    private MessageConverter messageConverter = new MessagingMessageConverter();

    public MessagingMessageListenerAdapter(Method method) {
        this.inferredType = this.determineInferredType(method);
    }

    public void setHandlerMethod(HandlerAdapter handlerMethod) {
        this.handlerMethod = handlerMethod;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    protected final MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    @Override
    public void onMessage(ConsumerRecord<K, V> record, Acknowledgment acknowledgment) {
        Message<?> message = this.toMessagingMessage(record, acknowledgment);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Processing [" + message + "]"));
        }
        this.invokeHandler(record, acknowledgment, message);
    }

    protected Message<?> toMessagingMessage(ConsumerRecord<K, V> record, Acknowledgment acknowledgment) {
        return this.getMessageConverter().toMessage(record, acknowledgment, this.inferredType);
    }

    private Object invokeHandler(ConsumerRecord<K, V> record, Acknowledgment acknowledgment, Message<?> message) {
        try {
            return this.handlerMethod.invoke(message, record, acknowledgment);
        }
        catch (MessageConversionException ex) {
            throw new ListenerExecutionFailedException(this.createMessagingErrorMessage("Listener method could not be invoked with the incoming message", message.getPayload()), new MessageConversionException("Cannot handle message", (Throwable)ex));
        }
        catch (MessagingException ex) {
            throw new ListenerExecutionFailedException(this.createMessagingErrorMessage("Listener method could not be invoked with the incoming message", message.getPayload()), ex);
        }
        catch (Exception ex) {
            throw new ListenerExecutionFailedException("Listener method '" + this.handlerMethod.getMethodAsString(message.getPayload()) + "' threw exception", ex);
        }
    }

    private String createMessagingErrorMessage(String description, Object payload) {
        return description + "\nEndpoint handler details:\nMethod [" + this.handlerMethod.getMethodAsString(payload) + "]\nBean [" + this.handlerMethod.getBean() + "]";
    }

    private Type determineInferredType(Method method) {
        if (method == null) {
            return null;
        }
        Type genericParameterType = null;
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            MethodParameter methodParameter = new MethodParameter(method, i);
            if (!this.eligibleParameter(methodParameter) || methodParameter.getParameterAnnotations().length != 0 && !methodParameter.hasParameterAnnotation(Payload.class)) continue;
            if (genericParameterType == null) {
                ParameterizedType parameterizedType;
                genericParameterType = methodParameter.getGenericParameterType();
                if (!(genericParameterType instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)genericParameterType).getRawType().equals(Message.class)) continue;
                genericParameterType = ((ParameterizedType)genericParameterType).getActualTypeArguments()[0];
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Ambiguous parameters for target payload for method " + method + "; no inferred type available"));
            }
            return null;
        }
        return genericParameterType;
    }

    private boolean eligibleParameter(MethodParameter methodParameter) {
        ParameterizedType parameterizedType;
        Type parameterType = methodParameter.getGenericParameterType();
        if (parameterType.equals(Acknowledgment.class) || parameterType.equals(ConsumerRecord.class)) {
            return false;
        }
        if (parameterType instanceof ParameterizedType && (parameterizedType = (ParameterizedType)parameterType).getRawType().equals(Message.class)) {
            return !(parameterizedType.getActualTypeArguments()[0] instanceof WildcardType);
        }
        return !parameterType.equals(Message.class);
    }
}

