/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.converter;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.cloud.stream.converter.AbstractFromMessageConverter;
import org.springframework.cloud.stream.converter.MessageConverterUtils;
import org.springframework.messaging.Message;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

public class ByteArrayToStringMessageConverter
extends AbstractFromMessageConverter {
    private static final List<MimeType> targetMimeTypes = new ArrayList<MimeType>();

    public ByteArrayToStringMessageConverter() {
        super(Arrays.asList(MimeTypeUtils.APPLICATION_OCTET_STREAM, MimeTypeUtils.TEXT_PLAIN), targetMimeTypes);
    }

    @Override
    protected Class<?>[] supportedTargetTypes() {
        return new Class[]{String.class};
    }

    @Override
    protected Class<?>[] supportedPayloadTypes() {
        return new Class[]{byte[].class};
    }

    public Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        MimeType mimeType = this.getContentTypeResolver().resolve(message.getHeaders());
        String converted = null;
        if (mimeType == null || mimeType.getParameter("Charset") == null) {
            converted = new String((byte[])message.getPayload());
        } else {
            String encoding = mimeType.getParameter("Charset");
            if (encoding != null) {
                try {
                    converted = new String((byte[])message.getPayload(), encoding);
                }
                catch (UnsupportedEncodingException e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return converted;
    }

    static {
        targetMimeTypes.add(MessageConverterUtils.X_JAVA_OBJECT);
        targetMimeTypes.add(MimeTypeUtils.TEXT_PLAIN);
    }
}

