/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.ecwid.consul.v1.ConsulClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.consul.ConditionalOnConsulEnabled;
import org.springframework.cloud.consul.discovery.ConsulCatalogWatch;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryClient;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.ConsulLifecycle;
import org.springframework.cloud.consul.discovery.HeartbeatProperties;
import org.springframework.cloud.consul.discovery.TtlScheduler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnConsulEnabled
@ConditionalOnProperty(value={"spring.cloud.consul.discovery.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties
public class ConsulDiscoveryClientConfiguration {
    @Autowired
    private ConsulClient consulClient;
    @Autowired(required=false)
    private ServerProperties serverProperties;

    @Bean
    @ConditionalOnMissingBean
    public ConsulLifecycle consulLifecycle(ConsulDiscoveryProperties discoveryProperties, HeartbeatProperties heartbeatProperties) {
        return new ConsulLifecycle(this.consulClient, discoveryProperties, heartbeatProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.cloud.consul.discovery.heartbeat.enabled"})
    public TtlScheduler ttlScheduler(HeartbeatProperties heartbeatProperties) {
        return new TtlScheduler(heartbeatProperties, this.consulClient);
    }

    @Bean
    public HeartbeatProperties heartbeatProperties() {
        return new HeartbeatProperties();
    }

    @Bean
    public ConsulDiscoveryProperties consulDiscoveryProperties(InetUtils inetUtils) {
        return new ConsulDiscoveryProperties(inetUtils);
    }

    @Bean
    @ConditionalOnMissingBean
    public ConsulDiscoveryClient consulDiscoveryClient(ConsulLifecycle consulLifecycle, ConsulDiscoveryProperties discoveryProperties) {
        ConsulDiscoveryClient discoveryClient = new ConsulDiscoveryClient(this.consulClient, consulLifecycle, discoveryProperties);
        discoveryClient.setServerProperties(this.serverProperties);
        return discoveryClient;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"spring.cloud.consul.discovery.catalogServicesWatch.enabled"}, matchIfMissing=true)
    public ConsulCatalogWatch consulCatalogWatch(ConsulDiscoveryProperties discoveryProperties) {
        return new ConsulCatalogWatch(discoveryProperties, this.consulClient);
    }
}

